% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeLoci.R
\name{summarizeLoci}
\alias{summarizeLoci}
\title{Locus Summaries}
\usage{
summarizeLoci(g, by.strata = FALSE, ...)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{by.strata}{logical. If \code{TRUE}, return a list of summary matrices 
for each stratum.}

\item{...}{arguments to be passed on to summary functions.}
}
\value{
A matrix with rows for each locus and columns containing summaries of:
  \tabular{ll}{
    \code{num.genotyped} \tab The number of samples genotyped.\cr
    \code{prop.genotyped} \tab The proportion of samples genotyped.\cr
    \code{num.alleles} \tab The number of alleles in the locus.\cr
    \code{allelic.richness} \tab The allelic richness of the locus.\cr
    \code{prop.unique.alleles} \tab Proportion of alleles found in a single sample.\cr
    \code{expt.heterozygosity} \tab Expected heterozygosity.\cr
    \code{obsvd.heterozygosity} \tab Observed heterozygosity.\cr
  }
}
\description{
Compile standard by-locus summaries.
}
\examples{
data(msats.g)
msats.g <- stratify(msats.g, "fine")

summarizeLoci(msats.g)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

