% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastsimcoal.input.R
\name{fastsimcoal.input}
\alias{fastsimcoal.input}
\alias{fscPopInfo}
\alias{fscLocusParams}
\alias{fscHistEv}
\title{Input functions for fastsimcoal parameters}
\usage{
fscPopInfo(pop.size, sample.size, sample.times = 0, growth.rate = 0)

fscLocusParams(locus.type = c("dna", "msat", "snp"), sequence.length = NULL,
  num.loci = NULL, mut.rate = NULL, transition.rate = 1/3,
  gsm.param = 0, range.constraint = 0, recomb.rate = 0,
  chromosome = NULL, num.chrom = NULL, ploidy = 2)

fscHistEv(num.gen = 0, source.deme = 0, sink.deme = 0,
  prop.migrants = 1, new.sink.size = 1, new.sink.growth = 0,
  new.mig.mat = 0)
}
\arguments{
\item{pop.size}{a vector giving size of each populaiton.}

\item{sample.size}{a vector giving the number of samples to take from each
population.}

\item{sample.times}{a vector giving the number of generations in the past
at which samples are taken.}

\item{growth.rate}{a vector giving the growth rate of each population.}

\item{locus.type}{a character representation of what type of marker to simulate.
Can be "dna", "msat", or "snp".}

\item{sequence.length}{\code{dna}: number of DNA base pairs to use.}

\item{num.loci}{\code{msat, snp}: number of loci to simulate.}

\item{mut.rate}{\code{dna, msat}: per base pair or locus mutation rate.}

\item{transition.rate}{dna: fraction of substitutions that are transitions. 
Set to 1 (all transitions) for SNPs.}

\item{gsm.param}{\code{msat}: Value of the geometric parameter for a
Generalized Stepwise Mutation (GSM) model. This value represents the
proportion of mutations that will change the allele size by more than
one step. Values between 0 and 1 are required. A value of 0 is for a
strict Stepwise Mutation Model (SMM).}

\item{range.constraint}{\code{msat}: Range constraint (number of different
alleles allowed). A value of 0 means no range constraint.}

\item{recomb.rate}{recombination rate between adjacent markers. No effect for 
SNPs.}

\item{chromosome}{number or character identifying which chromosome the marker
is on.}

\item{num.chrom}{a value giving the number of chromosomes that the
\code{locus.params} marker specifications should be copied for. If
\code{NULL}, then chromosome assignment is taken from the \code{chromosome} 
column. Any non-\code{NULL} integer will cause the value in \code{chromosome}.}

\item{ploidy}{positive integer giving the ploidy of the marker type to 
be simulated.}

\item{num.gen}{Number of generations, t, before present at which the
historical event happened.}

\item{source.deme}{Source deme (the first listed deme has index 0)}

\item{sink.deme}{Sink deme}

\item{prop.migrants}{Expected proportion of migrants to move from source to sink.}

\item{new.sink.size}{New size for the sink deme, relative to its size at
generation t.}

\item{new.sink.growth}{New growth rate for the sink deme.}

\item{new.mig.mat}{New migration matrix to be used further back in time.}
}
\description{
Functions to create \code{pop.info}, \code{locus.params}, and 
  \code{hist.ev} input matrices for fastsimcoal function.
}
\note{
SNPs are simulated as a diploid DNA sequence with a single nucleotide,
  with no recombination (each on its own "chromosome"). If \code{mut.rate} 
  has more than one value then this many SNPs are simulated. Otherwise, 
  \code{num.loci} independent SNPs are simulated.
}
\references{
Excoffier, L. and Foll, M (2011) fastsimcoal: a continuous-time 
  coalescent simulator of genomic diversity under arbitrarily complex 
  evolutionary scenarios Bioinformatics 27: 1332-1334.\cr
  \url{http://cmpg.unibe.ch/software/fastsimcoal2/}
}
\seealso{
\code{\link{fastsimcoal}}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
