% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mafft.R
\name{mafft}
\alias{mafft}
\title{MAFFT Alignment}
\usage{
mafft(
  x,
  run.label = "align.mafft",
  delete.output = TRUE,
  op = 3,
  ep = 0.123,
  maxiterate = 0,
  quiet = FALSE,
  num.cores = 1,
  opts = "--auto",
  simplify = TRUE
)
}
\arguments{
\item{x}{a list or a matrix of DNA sequences 
(see \code{\link[ape]{write.dna}}).}

\item{run.label}{label for output alignment FASTA file.}

\item{delete.output}{logical. Delete output alignment FASTA file?}

\item{op}{gap opening penalty.}

\item{ep}{offset value, which works like gap extension penalty.}

\item{maxiterate}{number cycles of iterative refinement are performed.}

\item{quiet}{logical. Run MAFFT quietly?}

\item{num.cores}{The number of cores to use. If set to \code{NULL}, 
the value will be what is reported by 
\code{\link[parallel]{detectCores} - 1}. Passed to MAFFT argument 
\code{--thread}.}

\item{opts}{character string other options to provide to command line.}

\item{simplify}{if \code{TRUE}, if \code{x} is a single sequence, 
a single \code{DNAbin} object is returned, otherwise, a list of alignments
is returned.}
}
\value{
a \code{\link[ape]{DNAbin}} object with aligned sequences.
}
\description{
Align a set of sequences using the MAFFT executable.
}
\note{
MAFFT is not included with \code{strataG} and must be downloaded 
  separately. Additionally, it must be installed such that it can be run from 
  the command line in the current working directory. See the vignette 
  for \code{external.programs} for installation instructions.
}
\examples{
\dontrun{
data(dolph.seqs)
dolph.aln <- mafft(dolph.seqs, op = 3, ep = 2)
dolph.aln
}

}
\references{
Katoh, M., Kumar, M. 2002. MAFFT: a novel method for rapid multiple sequence 
  alignment based on fast Fourier transform. Nucleic Acids Res. 30:3059-3066.\cr 
  Available at: \url{http://mafft.cbrc.jp/alignment/software}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
