% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_assignment.R
\name{get_assignment}
\alias{get_assignment}
\alias{get_assignment.DSC}
\title{Assignment Data Points to Clusters \link{deprecated}}
\usage{
get_assignment(
  dsc,
  points,
  type = c("auto", "micro", "macro"),
  method = "auto",
  ...
)

\method{get_assignment}{DSC}(
  dsc,
  points,
  type = c("auto", "micro", "macro"),
  method = c("auto", "nn", "model"),
  ...
)
}
\arguments{
\item{dsc}{The \link{DSC} object with the clusters for assignment.}

\item{points}{The points to be assigned as a data.frame.}

\item{type}{Use micro- or macro-clusters in \link{DSC} for assignment.}

\item{method}{assignment method
\itemize{
\item \code{"model"} uses the assignment method of the underlying algorithm
(unassigned points return \code{NA}). Not all algorithms implement this option.
\item \code{"nn"} performs nearest neighbor assignment using Euclidean distance.
\item \code{"auto"} uses the model assignment method. If this method is not
implemented/available then method \code{"nn"} is used instead.
}}

\item{...}{Additional arguments are passed on.}
}
\value{
A vector containing the assignment of each point. \code{NA} means
that a data point was not assigned to a cluster.
}
\description{
\strong{Deprecation Notice:} use \code{\link[=predict]{predict()}} for a more general interface to apply
a data stream model to new data. \code{get_assignment()} is deprecated.
}
\details{
Get the assignment of data points to clusters in a \code{DSC} using the
model's assignment rules or nearest neighbor assignment. The clustering is
not modified.

Each data point is assigned either using the original model's assignment
rule or Euclidean nearest neighbor assignment. If the user specifies the
model's assignment strategy, but is not available, then nearest neighbor
assignment is used and a warning is produced.
}
\examples{
stream <- DSD_Gaussians(k = 3, d = 2, noise = .05)

dbstream <- DSC_DBSTREAM(r = .1)
update(dbstream, stream, n = 100)

# find the assignment for the next 100 points to
# micro-clusters in dsc. This uses the model's assignment function
points <- get_points(stream, n = 100)
a <- predict(dbstream, points)
head(a)

# show the MC assignment areas. Assigned points as blue circles and
# the unassigned points as red dots
plot(dbstream, stream, assignment = TRUE, type = "none")
points(points[!is.na(a[, ".class"]),], col = "blue")
points(points[is.na(a[, ".class"]),], col = "red", pch = 20)

# use nearest neighbor assignment instead
a <- predict(dbstream, points, method = "nn")
head(a)
}
\seealso{
Other DSC: 
\code{\link{DSC_Macro}()},
\code{\link{DSC_Micro}()},
\code{\link{DSC_R}()},
\code{\link{DSC_SlidingWindow}()},
\code{\link{DSC_Static}()},
\code{\link{DSC_TwoStage}()},
\code{\link{DSC}()},
\code{\link{animate_cluster}()},
\code{\link{evaluate.DSC}},
\code{\link{plot.DSC}()},
\code{\link{predict}()},
\code{\link{prune_clusters}()},
\code{\link{read_saveDSC}},
\code{\link{recluster}()}
}
\author{
Michael Hahsler
}
\concept{DSC}
