/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.core.splitcriteria;

import moa.classifiers.rules.core.splitcriteria.AMRulesSplitCriterion;
import moa.classifiers.rules.core.splitcriteria.SDRSplitCriterionAMRules;

public class SDRSplitCriterionAMRulesNode
extends SDRSplitCriterionAMRules
implements AMRulesSplitCriterion {
    private static final long serialVersionUID = 1L;

    @Override
    public double getMeritOfSplit(double[] preSplitDist, double[][] postSplitDists) {
        double SDR = 0.0;
        int count = 0;
        for (int i = 0; i < postSplitDists.length; ++i) {
            double Ni = postSplitDists[i][0];
            if (!(Ni >= 0.05 * preSplitDist[0])) continue;
            ++count;
        }
        if (count == postSplitDists.length) {
            SDR = SDRSplitCriterionAMRulesNode.computeSD(preSplitDist);
            double min = Double.MAX_VALUE;
            for (int i = 0; i < postSplitDists.length; ++i) {
                double val = SDRSplitCriterionAMRulesNode.computeSD(postSplitDists[i]);
                if (!(val < min)) continue;
                min = val;
            }
            SDR -= min;
        }
        return SDR;
    }

    @Override
    public double[] computeBranchSplitMerits(double[][] postSplitDists) {
        double[] SDR = new double[postSplitDists.length];
        for (int i = 0; i < postSplitDists.length; ++i) {
            SDR[i] = SDRSplitCriterionAMRulesNode.computeSD(postSplitDists[i]);
        }
        return SDR;
    }

    @Override
    public double getRangeOfMerit(double[] preSplitDist) {
        return 1.0;
    }
}

