/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import com.github.javacliparser.FileOption;
import com.github.javacliparser.FlagOption;
import com.github.javacliparser.IntOption;
import moa.clusterers.AbstractClusterer;
import moa.core.ObjectRepository;
import moa.options.ClassOption;
import moa.streams.clustering.ClusteringStream;
import moa.streams.clustering.FileStream;
import moa.tasks.AuxiliarMainTask;
import moa.tasks.EvaluateClustering;
import moa.tasks.TaskMonitor;

public class EvaluateMultipleClusterings
extends AuxiliarMainTask {
    private static final long serialVersionUID = 4846907962483608940L;
    String defaultfile = "covtypeNorm.arff";
    public ClassOption learnerOption = new ClassOption("learner", 'l', "Clusterer to train.", AbstractClusterer.class, "clustream.Clustream");
    public ClassOption streamOption = new ClassOption("stream", 's', "Base stream to learn from (must use FileStream).", ClusteringStream.class, "FileStream");
    public IntOption numStreamsOption = new IntOption("numStreams", 'n', "The number of streams to iterate through (must be named according to WriteMultipleStreamsToARFF format.", 100, 2, Integer.MAX_VALUE);
    public FlagOption generalEvalOption = new FlagOption("General", 'g', "GPrecision, GRecall, Redundancy, numCluster, numClasses");
    public FlagOption f1Option = new FlagOption("F1", 'f', "F1-P, F1-R, Purity.");
    public FlagOption entropyOption = new FlagOption("Entropy", 'e', "GT cross entropy, FC cross entropy, Homogeneity, Completeness, V-Measure, VarInformation.");
    public FlagOption cmmOption = new FlagOption("CMM", 'c', "CMM, CMM Basic, CMM Missed, CMM Misplaced, CMM Noise, CA Seperability, CA Noise, CA Model.");
    public FlagOption ssqOption = new FlagOption("SSQ", 'q', "SSQ.");
    public FlagOption separationOption = new FlagOption("Separation", 'p', "BSS, BSS-GT, BSS-Ratio.");
    public FlagOption silhouetteOption = new FlagOption("Silhouette", 'h', "SilhCoeff.");
    public FlagOption statisticalOption = new FlagOption("Statistical", 't', "van Dongen, Rand statistic.");
    public FileOption dumpFileOption = new FileOption("dumpFile", 'd', "File to append intermediate csv reslts to.", "dumpClustering.csv", "csv", true);
    protected EvaluateClustering task;

    @Override
    public String getPurposeString() {
        return "Evaluates a clusterer on multiple (related) streams.";
    }

    @Override
    public Class<?> getTaskResultType() {
        return Object.class;
    }

    @Override
    protected Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        Object result = null;
        for (int i = 0; i < this.numStreamsOption.getValue(); ++i) {
            this.task = new EvaluateClustering();
            this.task.learnerOption.setValueViaCLIString(this.learnerOption.getValueAsCLIString());
            FileStream fStream = (FileStream)this.getPreparedClassOption(this.streamOption);
            String arffFile = fStream.arffFileOption.getValueAsCLIString();
            arffFile = arffFile.substring(0, arffFile.length() - 6).concat(i + ".arff");
            fStream.arffFileOption.setValueViaCLIString(arffFile);
            this.task.streamOption.setValueViaCLIString(fStream.getCLICreationString(fStream.getClass()));
            String outputFile = this.dumpFileOption.getValueAsCLIString();
            if (outputFile.substring(outputFile.length() - 4, outputFile.length()).equals(".csv")) {
                outputFile = outputFile.substring(0, outputFile.length() - 4);
            }
            outputFile = outputFile.concat("n" + i + ".csv");
            this.task.dumpFileOption.setValueViaCLIString(outputFile);
            this.task.instanceLimitOption.setValue(-1);
            boolean[] measureCollection = new boolean[]{this.generalEvalOption.isSet(), this.f1Option.isSet(), this.entropyOption.isSet(), this.cmmOption.isSet(), this.ssqOption.isSet(), this.separationOption.isSet(), this.silhouetteOption.isSet(), this.statisticalOption.isSet()};
            this.task.setMeasures(measureCollection);
            System.out.println("Evaluation #" + (i + 1) + " of " + this.numStreamsOption.getValue() + ": " + this.task.getCLICreationString(this.task.getClass()));
            result = this.task.doTask(monitor, repository);
        }
        return result;
    }
}

