/*
 * Decompiled with CFR 0.152.
 */
package moa.capabilities;

import java.util.function.Predicate;
import moa.capabilities.Capabilities;
import moa.capabilities.CapabilitiesHandler;
import moa.capabilities.Capability;
import moa.capabilities.ImmutableCapabilities;

public class CapabilityRequirement {
    public static final ImmutableCapabilities NON_HANDLER_CAPABILITIES = new ImmutableCapabilities(Capability.VIEW_STANDARD, Capability.VIEW_LITE);
    private Predicate<Capabilities> m_Test;

    public CapabilityRequirement(Predicate<Capabilities> check) {
        if (check == null) {
            throw new IllegalArgumentException("Capability requirement cannot be null");
        }
        this.m_Test = check;
    }

    public boolean isMetBy(Capabilities capabilities) {
        return this.m_Test.test(capabilities);
    }

    public boolean isMetBy(CapabilitiesHandler handler) {
        return this.isMetBy(handler.getCapabilities());
    }

    public boolean isMetBy(Class<?> klass) {
        CapabilitiesHandler instance;
        if (!CapabilitiesHandler.class.isAssignableFrom(klass)) {
            return this.isMetBy(NON_HANDLER_CAPABILITIES);
        }
        try {
            instance = (CapabilitiesHandler)klass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Couldn't instantiate CapabilitiesHandler " + klass.getSimpleName(), e);
        }
        return this.isMetBy(instance);
    }

    public CapabilityRequirement or(CapabilityRequirement other) {
        return new CapabilityRequirement(this.m_Test.or(other.m_Test));
    }

    public static CapabilityRequirement hasAll(Capability ... capabilities) {
        return new CapabilityRequirement(c -> {
            for (Capability capability : capabilities) {
                if (c.hasCapability(capability)) continue;
                return false;
            }
            return true;
        });
    }

    public static CapabilityRequirement hasAny(Capability ... capabilities) {
        return new CapabilityRequirement(c -> {
            for (Capability capability : capabilities) {
                if (!c.hasCapability(capability)) continue;
                return true;
            }
            return false;
        });
    }

    public static CapabilityRequirement has(Capability capability) {
        return new CapabilityRequirement(c -> c.hasCapability(capability));
    }
}

