/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.MultiLabelPrediction;
import com.yahoo.labs.samoa.instances.Prediction;
import moa.AbstractMOAObject;
import moa.core.Example;
import moa.core.Measurement;
import moa.evaluation.MultiTargetPerformanceEvaluator;
import moa.evaluation.RegressionPerformanceEvaluator;

public class BasicMultiTargetPerformanceRelativeMeasuresEvaluator
extends AbstractMOAObject
implements MultiTargetPerformanceEvaluator,
RegressionPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    protected double weightObserved;
    protected double[] squareError;
    protected double[] averageError;
    protected double[] averageErrorToTargetMean;
    protected double[] squareErrorToTargetMean;
    protected double[] sumY;
    protected int numberOutputs;

    @Override
    public void reset() {
        this.weightObserved = 0.0;
        this.squareError = null;
        this.averageError = null;
        this.averageErrorToTargetMean = null;
        this.squareErrorToTargetMean = null;
        this.sumY = null;
    }

    @Override
    public void addResult(Example<Instance> example, Prediction prediction) {
        MultiLabelInstance inst = (MultiLabelInstance)example.getData();
        if (this.numberOutputs == 0) {
            this.numberOutputs = inst.numberOutputTargets();
        }
        if (this.squareError == null) {
            this.squareError = new double[this.numberOutputs];
            this.averageError = new double[this.numberOutputs];
            this.averageErrorToTargetMean = new double[this.numberOutputs];
            this.squareErrorToTargetMean = new double[this.numberOutputs];
            this.sumY = new double[this.numberOutputs];
        }
        if (inst.weight() > 0.0) {
            this.weightObserved += inst.weight();
            if (prediction != null && prediction.numOutputAttributes() > 0) {
                int i = 0;
                while (i < this.numberOutputs) {
                    double error = inst.valueOutputAttribute(i) - prediction.getVote(i, 0);
                    int n = i;
                    this.sumY[n] = this.sumY[n] + inst.valueOutputAttribute(i);
                    double errorTM = inst.valueOutputAttribute(i) - this.sumY[i] / this.weightObserved;
                    int n2 = i;
                    this.averageErrorToTargetMean[n2] = this.averageErrorToTargetMean[n2] + Math.abs(errorTM);
                    int n3 = i;
                    this.squareErrorToTargetMean[n3] = this.squareErrorToTargetMean[n3] + errorTM * errorTM;
                    int n4 = i;
                    this.averageError[n4] = this.averageError[n4] + Math.abs(error);
                    int n5 = i++;
                    this.squareError[n5] = this.squareError[n5] + error * error;
                }
            }
        }
    }

    @Override
    public Measurement[] getPerformanceMeasurements() {
        return new Measurement[]{new Measurement("classified instances", this.getTotalWeightObserved()), new Measurement("relative mean absolute error", this.getMeanError()), new Measurement("relative root mean squared error", this.getSquareError())};
    }

    public double getTotalWeightObserved() {
        return this.weightObserved;
    }

    public double getMeanError() {
        double error = 0.0;
        if (this.weightObserved > 0.0) {
            for (int i = 0; i < this.averageError.length; ++i) {
                error += this.averageError[i] / this.averageErrorToTargetMean[i];
            }
            error /= (double)this.numberOutputs;
        }
        return error;
    }

    public double getSquareError() {
        double error = 0.0;
        if (this.weightObserved > 0.0) {
            for (int i = 0; i < this.squareError.length; ++i) {
                error += Math.sqrt(this.squareError[i] / this.squareErrorToTargetMean[i]);
            }
            error /= (double)this.numberOutputs;
        }
        return error;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        Measurement.getMeasurementsDescription(this.getPerformanceMeasurements(), sb, indent);
    }

    @Override
    public void addResult(Example<Instance> example, double[] classVotes) {
        MultiLabelPrediction p = new MultiLabelPrediction(1);
        p.setVotes(classVotes);
        this.addResult(example, (Prediction)p);
    }
}

