/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks.meta;

import com.github.javacliparser.FileOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import moa.classifiers.active.ALClassifier;
import moa.core.Example;
import moa.core.Measurement;
import moa.core.ObjectRepository;
import moa.core.TimingUtils;
import moa.evaluation.ALClassificationPerformanceEvaluator;
import moa.evaluation.LearningEvaluation;
import moa.evaluation.preview.LearningCurve;
import moa.evaluation.preview.PreviewCollectionLearningCurveWrapper;
import moa.options.ClassOption;
import moa.streams.ExampleStream;
import moa.tasks.TaskMonitor;
import moa.tasks.meta.ALMainTask;
import moa.tasks.meta.ALTaskThread;

public class ALPrequentialEvaluationTask
extends ALMainTask {
    private static final long serialVersionUID = 1L;
    public ClassOption learnerOption = new ClassOption("learner", 'l', "Learner to train.", ALClassifier.class, "moa.classifiers.active.ALRandom");
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to learn from.", ExampleStream.class, "generators.RandomTreeGenerator");
    public ClassOption evaluatorOption = new ClassOption("evaluator", 'e', "Active Learning classification performance evaluation method.", ALClassificationPerformanceEvaluator.class, "ALWindowClassificationPerformanceEvaluator");
    public IntOption instanceLimitOption = new IntOption("instanceLimit", 'i', "Maximum number of instances to test/train on  (-1 = no limit).", 100000000, -1, Integer.MAX_VALUE);
    public IntOption timeLimitOption = new IntOption("timeLimit", 't', "Maximum number of seconds to test/train for (-1 = no limit).", -1, -1, Integer.MAX_VALUE);
    public IntOption sampleFrequencyOption = new IntOption("sampleFrequency", 'f', "How many instances between samples of the learning performance.", 100000, 0, Integer.MAX_VALUE);
    public FileOption dumpFileOption = new FileOption("dumpFile", 'd', "File to append intermediate csv results to.", null, "csv", true);

    @Override
    public String getPurposeString() {
        return "Perform prequential evaluation (testing, then training with each example in sequence) for an active learning classifier.";
    }

    public ALPrequentialEvaluationTask() {
        this(Color.BLACK);
    }

    public ALPrequentialEvaluationTask(Color colorCoding) {
        this.colorCoding = colorCoding;
    }

    @Override
    public Class<?> getTaskResultType() {
        return LearningCurve.class;
    }

    @Override
    protected Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        long evaluateStartTime;
        ExampleStream stream = (ExampleStream)this.getPreparedClassOption(this.streamOption);
        ALClassifier learner = (ALClassifier)this.getPreparedClassOption(this.learnerOption);
        learner.resetLearning();
        learner.setModelContext(stream.getHeader());
        ALClassificationPerformanceEvaluator evaluator = (ALClassificationPerformanceEvaluator)this.getPreparedClassOption(this.evaluatorOption);
        LearningCurve learningCurve = new LearningCurve("learning evaluation instances");
        int maxInstances = this.instanceLimitOption.getValue();
        int instancesProcessed = 0;
        int maxSeconds = this.timeLimitOption.getValue();
        int secondsElapsed = 0;
        boolean firstDump = true;
        boolean preciseCPUTiming = TimingUtils.enablePreciseTiming();
        long lastEvaluateStartTime = evaluateStartTime = TimingUtils.getNanoCPUTimeOfCurrentThread();
        double RAMHours = 0.0;
        File dumpFile = this.dumpFileOption.getFile();
        PrintStream immediateResultStream = null;
        if (dumpFile != null) {
            try {
                immediateResultStream = dumpFile.exists() ? new PrintStream(new FileOutputStream(dumpFile, true), true) : new PrintStream(new FileOutputStream(dumpFile), true);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to open immediate result file: " + dumpFile, ex);
            }
        }
        monitor.setCurrentActivity("Evaluating learner...", -1.0);
        while (!(!stream.hasMoreInstances() || maxInstances >= 0 && instancesProcessed >= maxInstances || maxSeconds >= 0 && secondsElapsed >= maxSeconds)) {
            Object trainInst;
            Object testInst = trainInst = stream.nextInstance();
            double[] prediction = learner.getVotesForInstance(testInst);
            evaluator.addResult(testInst, prediction);
            learner.trainOnInstance(trainInst);
            int labelAcquired = learner.getLastLabelAcqReport();
            evaluator.doLabelAcqReport((Example<Instance>)trainInst, labelAcquired);
            if (++instancesProcessed % this.sampleFrequencyOption.getValue() == 0 || !stream.hasMoreInstances()) {
                long evaluateTime = TimingUtils.getNanoCPUTimeOfCurrentThread();
                double time = TimingUtils.nanoTimeToSeconds(evaluateTime - evaluateStartTime);
                double timeIncrement = TimingUtils.nanoTimeToSeconds(evaluateTime - lastEvaluateStartTime);
                double RAMHoursIncrement = (double)learner.measureByteSize() / 1.073741824E9;
                lastEvaluateStartTime = evaluateTime;
                learningCurve.insertEntry(new LearningEvaluation(new Measurement[]{new Measurement("learning evaluation instances", instancesProcessed), new Measurement("evaluation time (" + (preciseCPUTiming ? "cpu " : "") + "seconds)", time), new Measurement("model cost (RAM-Hours)", RAMHours += (RAMHoursIncrement *= timeIncrement / 3600.0))}, evaluator, learner));
                if (immediateResultStream != null) {
                    if (firstDump) {
                        immediateResultStream.println(learningCurve.headerToString());
                        firstDump = false;
                    }
                    immediateResultStream.println(learningCurve.entryToString(learningCurve.numEntries() - 1));
                    immediateResultStream.flush();
                }
            }
            if (instancesProcessed % 10 != 0 || learningCurve.numEntries() <= 0) continue;
            if (monitor.taskShouldAbort()) {
                return null;
            }
            long estimatedRemainingInstances = stream.estimatedRemainingInstances();
            if (maxInstances > 0) {
                long maxRemaining = maxInstances - instancesProcessed;
                if (estimatedRemainingInstances < 0L || estimatedRemainingInstances == 0L || maxRemaining < estimatedRemainingInstances) {
                    estimatedRemainingInstances = maxRemaining;
                }
            }
            double fractionComplete = (double)instancesProcessed / (double)((long)instancesProcessed + estimatedRemainingInstances);
            monitor.setCurrentActivityFractionComplete(estimatedRemainingInstances < 0L ? -1.0 : fractionComplete);
            if (monitor.resultPreviewRequested() || this.isSubtask()) {
                monitor.setLatestResultPreview(new PreviewCollectionLearningCurveWrapper((LearningCurve)learningCurve.copy(), this.getClass()));
            }
            secondsElapsed = (int)TimingUtils.nanoTimeToSeconds(TimingUtils.getNanoCPUTimeOfCurrentThread() - evaluateStartTime);
        }
        if (immediateResultStream != null) {
            immediateResultStream.close();
        }
        return new PreviewCollectionLearningCurveWrapper(learningCurve, this.getClass());
    }

    @Override
    public List<ALTaskThread> getSubtaskThreads() {
        return new ArrayList<ALTaskThread>();
    }
}

