# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Fast row sums
#' 
#' Demonstration of fast row and columns sums in C++
#' 
#' @param x a numeric matrix
#' 
#' @details A very efficient row summing algorithm that demonstrates
#' the use of the strided pointer concept. The \code{row_sum} algorithm is
#' roughly twice as fast as \code{\link{rowSums}}. The \code{col_sum} algorithm 
#' matches \code{\link{colSums}} for speed.
#'
#' @examples
#' row_sums(matrix(1:9, 3))
#' col_sums(matrix(1:9, 3))
#' 
#' @seealso \code{\link{rowSums}}, \code{\link{colSums}}
#' @rdname sums
#' @export
row_sums <- function(x) {
    .Call(`_strider_row_sums`, x)
}

#' @rdname sums
#' @export
col_sums <- function(x) {
    .Call(`_strider_col_sums`, x)
}

#' Convolve Matrices
#' 
#' Demonstration of fast matrix convolution C++
#' 
#' @param a a numeric matrix
#' @param b a numeric matrix
#' 
#' @details A very efficient matric convolution implementation that demonstrates
#' the use of the strided pointer and strided range concepts. Performance will be
#' improved if the smaller matrix is given as the second argument.
#'
#' @examples
#' a = matrix(c(1, 2, 1,
#'              1, 1, 1), 2, 3, byrow = TRUE)
#' b = matrix(c(0, 0, 0,
#'              0, 0, 0,
#'              0, 1, 0,
#'              0, 0, 0), 4, 3, byrow = TRUE)
#' convolve2(a, b)
#' 
#' @seealso \code{\link{convolve}}
#' @rdname convolve
#' @export
convolve2 <- function(a, b) {
    .Call(`_strider_convolve2`, a, b)
}

