% Generated by roxygen2 (4.0.0): do not edit by hand
\name{stri_split_fixed}
\alias{stri_split_fixed}
\title{Split a String By Fixed Pattern Matches}
\usage{
stri_split_fixed(str, pattern, n_max = -1L, omit_empty = FALSE)
}
\arguments{
\item{str}{character vector with strings to search in}

\item{pattern}{character vector with fixed patterns}

\item{n_max}{integer vector, maximal number of pieces to return}

\item{omit_empty}{logical vector; determines whether empty
strings should be removed from the result}
}
\value{
Returns a list of character vectors.
}
\description{
Splits each element of \code{str} into substrings.
\code{pattern} indicates delimiters that separate
the input into fields. The input data between the matches become
the fields themselves.
}
\details{
Vectorized over \code{str}, \code{pattern}, \code{n_max}, and \code{omit_empty}.

If \code{n_max} is negative (default), then all pieces are extracted.

\code{omit_empty} is applied during splitting: if set to \code{TRUE},
then empty strings will never appear in the resulting vector.

For natural language processing this function may be not give
you desired results. Refer to \link{stringi-search-fixed} for more details.
}
\examples{
\dontshow{if (stri_install_check(silent=TRUE))}
stri_split_fixed("Lorem ipsum dolor sit amet", " ")
}
\seealso{
Other search_fixed: \code{\link{stri_count_fixed}};
  \code{\link{stri_detect_fixed}};
  \code{\link{stri_locate_all_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_last_fixed}},
  \code{\link{stri_locate_last_fixed}};
  \code{\link{stri_replace_all_fixed}},
  \code{\link{stri_replace_first_fixed}},
  \code{\link{stri_replace_first_fixed}},
  \code{\link{stri_replace_last_fixed}},
  \code{\link{stri_replace_last_fixed}};
  \code{\link{stringi-search-fixed}};
  \code{\link{stringi-search}}

Other search_split: \code{\link{stri_split_boundaries}};
  \code{\link{stri_split_charclass}};
  \code{\link{stri_split_coll}};
  \code{\link{stri_split_lines}},
  \code{\link{stri_split_lines1}},
  \code{\link{stri_split_lines1}};
  \code{\link{stri_split_regex}}; \code{\link{stri_split}};
  \code{\link{stringi-search}}
}

