% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateLb.r
\name{calculateLb}
\alias{calculateLb}
\title{Calculate Inter-locus Balance}
\usage{
calculateLb(data, ref = NULL, option = "prop", by.dye = FALSE,
  ol.rm = TRUE, sex.rm = FALSE, qs.rm = FALSE, na = NULL, kit = NULL,
  ignore.case = TRUE, word = FALSE, exact = FALSE, debug = FALSE)
}
\arguments{
\item{data}{data.frame containing at least
'Sample.Name', 'Marker', and 'Height'.}

\item{ref}{data.frame containing at least 'Sample.Name', 'Marker', 'Allele'.
If provided alleles matching 'ref' will be extracted from 'data'
(see \code{\link{filterProfile}}).}

\item{option}{character: 'prop' for proportional Lb, 'norm' for normalised
LB, and 'cent' for centred Lb.}

\item{by.dye}{logical. Default is FALSE for global Lb, if TRUE Lb is calculated
within each dye channel.}

\item{ol.rm}{logical. Default is TRUE indicating that off-ladder 'OL' alleles
will be removed.}

\item{sex.rm}{logical. Default is FALSE indicating that all markers will be
considered. If TRUE sex markers will be removed.}

\item{qs.rm}{logical. Default is TRUE indicating that all quality sensors
will be removed.}

\item{na}{numeric. Numeric to replace NA values e.g. locus dropout can be 
given a peak height equal to the limit of detection threshold, or zero.
Default is NULL indicating that NA will be treated as missing values.}

\item{kit}{character providing the kit name. Attempt to autodetect if NULL.}

\item{ignore.case}{logical indicating if sample matching should ignore case.
Only used if 'ref' is provided and 'data' is filtered.}

\item{word}{logical indicating if word boundaries should be added before sample matching.
Only used if 'ref' is provided and 'data' is filtered.}

\item{exact}{logical indicating if exact sample matching should be used.
Only used if 'ref' is provided and 'data' is filtered.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with at least columns 'Sample.Name', 'Marker', 'TPH', 'Peaks', and 'Lb'.
See description for additional columns.
}
\description{
Calculates the inter-locus balance.
}
\details{
The inter-locus balance (Lb), or profile balance, can be calculated
as a proportion of the whole, normalised, or as centred quantities (as in
the reference but using the mean total marker peak height instead of H).
Lb can be calculated globally across the complete profile or within each dye
channel. All markers must be present in each sample. Data can be unfiltered
or filtered since the sum of peak heights by marker is used. A reference
dataset is required to filter the dataset, which also adds any missing
markers. A kit should be provided for filtering of known profile, sex
markers, or quality sensors. If not automatic detection will be attempted.
If missing, dye will be added according to kit. Off-ladder alleles and
quality sensors are by default removed from the dataset.
Sex markers are optionally removed. 
Some columns in the result may vary:
TPH: Total (marker) Peak Height.
TPPH: Total Profile Peak Height.
MTPH: Maximum (sample) Total Peak Height.
MPH: Mean (marker) Peak Height.
}
\examples{
# Load data.
data(set2)

# Calculate inter-locus balance.
res <- calculateLb(data = set2)
print(res)

}
\references{
Torben Tvedebrink et.al.,
 Performance of two 17 locus forensic identification STR kits-Applied
 Biosystems's AmpFlSTR NGMSElect and Promega's PowerPlex ESI17 kits,
 Forensic Science International: Genetics, Volume 6, Issue 5, September 2012,
 Pages 523-531, ISSN 1872-4973, 10.1016/j.fsigen.2011.12.006.
\url{http://www.sciencedirect.com/science/article/pii/S1872497311002365}
}

