% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addOrder.r
\name{addOrder}
\alias{addOrder}
\title{Add Marker Order.}
\usage{
addOrder(data, kit = NULL, overwrite = FALSE, ignore.case = FALSE,
  debug = FALSE)
}
\arguments{
\item{data}{data frame or vector.}

\item{kit}{string representing the forensic STR kit used.
Default is NULL and autodetection of kit will be attempted.}

\item{overwrite}{logical if TRUE and column exist it will be overwritten.}

\item{ignore.case}{logical if TRUE case in marker names will be ignored.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with additional numeric column 'Order'.
}
\description{
Add marker order to data frame containing a column 'Marker'.
}
\details{
Markers in a kit appear in a certain order. Not all STR-validator functions
keep the original marker order in the result. A column indicating the marker
order is added to the dataset. This is especially useful when exporting the
data to an external spread-sheet software and allow to quickly sort the data
in the correct order.
}
\examples{
# Load a dataset containing two samples.
data("set2")
# Add marker order when kit is known.
addOrder(data = set2, kit = "SGMPlus")
}
