% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateSlope.r
\name{calculateSlope}
\alias{calculateSlope}
\title{Calculate Profile Slope.}
\usage{
calculateSlope(data, ref, conf = 0.975, kit = NULL, debug = FALSE,
  ...)
}
\arguments{
\item{data}{data.frame with at least columns 'Sample.Name', 'Marker', and
'Height'.}

\item{ref}{data.frame with at least columns 'Sample.Name', 'Marker',
and 'Allele'}

\item{conf}{numeric confidence limit to calculate a confidence interval from
(Student t Distribution with 'Peaks'-2 degree of freedom). Default is 0.975
corresponding to a 95\% confidence interval.}

\item{kit}{character string or vector specifying the analysis kits used
to produce the data. If length(kit) != number of groups, kit[1] will be
used for all groups.}

\item{debug}{logical indicating printing debug information.}

\item{...}{additional arguments to the \code{\link{filterProfile}} function}
}
\value{
data.frame with with columns 'Sample.Name', 'Kit', 'Group', 'Slope',
'Error', 'Peaks', 'Lower', and 'Upper'.
}
\description{
Calculate profile slope for samples.
}
\details{
Calculates the profile slope for each sample. The slope is calculated as a
linear model specified by the response (natural logarithm of peak height) by
the term size (in base pair). If 'Size' is not present in the dataset, one or
multiple kit names can be given as argument 'kit'. The specified kits will
be used to estimate the size of each allele. If 'kit' is NULL the kit(s)
will be automatically detected, and the 'Size' will be calculated.

The column 'Group' can be used to separate datasets to be compared, and if
so 'kit' must be a vector of equal length as the number of groups, and in
the same order. If not the first 'kit' will be recycled for all groups.

Data will be filtered using the reference profiles.
}
