% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateAllT.r
\name{calculateAllT}
\alias{calculateAllT}
\title{Calculate Stochastic Thresholds}
\usage{
calculateAllT(data, kit, p.dropout = 0.01, p.conservative = 0.05,
  rm.sex = TRUE, debug = FALSE)
}
\arguments{
\item{data}{output from \code{\link{calculateDropout}}.}

\item{kit}{character string to define the kit which is required to remove sex markers.}

\item{p.dropout}{numeric accepted risk of dropout at the stochastic threshold. Default=0.01.}

\item{p.conservative}{numeric accepted risk that the actual probability of
dropout is >p.dropout at the conservative estimate. Default=0.05.}

\item{rm.sex}{logical default=TRUE removes sex markers defined for the given \code{kit}.}

\item{debug}{logical indicating printing debug information.}
}
\value{
TRUE
}
\description{
Calculates point estimates for the stochastic threshold using multiple models.
}
\details{
Expects output from \code{\link{calculateDropout}} as input.
The function calls \code{\link{calculateT}} repeatedly to estimate the
stochastic threshold using different models. The output is a data.frame
summarizing the result. Use the \code{\link{modelDropout_gui}} to plot
individual models.

Explanation of the result:
Explanatory_variable - Drop-out is the dependent variable.
An allele in heterozygous markers in the reference profile is chosen and
drop-out is scored if the other allele is not observed in the sample, i.e.
below the LDT. The 'Random' method chose a random allele, while the 'LMW'
and 'HMW' method chose the low and high molecular weight allele, respectively.
The 'Locus' method score drop-out if any of the two alleles has dropped out.
As explanatory variable the peak height of the surviving allele '(Ph)',
average profile peak height '(H)', the logarithm of the surviving allele
'log(Ph)', and the logarithm of the average profile peak height 'log(H)'
is used.
P(dropout)=x.xx@T - is the point estimate for corresponding to
the specified accepted risk of drop-out.
P(dropout>x.xx)<0.05@T - is the conservative point estimate corresponding
to a stochastic threshold with a risk <0.05 that the actual drop-out
probability is >x.xx
Hosmer-Lemeshow_p - p-value from the Hosmer-Lemeshow test. A value <0.05
indicates poor fit between the model and the observations.
}
\seealso{
\code{\link{calculateDropout}}, \code{\link{calculateT}},
 \code{\link{modelDropout_gui}}, \code{\link{plotDropout_gui}}
}
