% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_interval.R
\name{check_interval}
\alias{check_interval}
\title{Checks if a given interval is a sudden gain/loss}
\usage{
check_interval(pre_values, post_values, sg_crit1_cutoff,
  sg_crit2_pct = 0.25, sg_crit3 = TRUE, sg_crit3_alpha = 0.05,
  identify = c("sg", "sl"), details = TRUE)
}
\arguments{
\item{pre_values}{Vector, three pre gain/loss values to be checked for a sudden gain/loss (n-2, n-1, n)}

\item{post_values}{Vector, three post gain/loss values to be checked for a sudden gain/loss (n+1, n+2, n+3)}

\item{sg_crit1_cutoff}{Numeric, specifying the cut-off value to be used for the first sudden gains criterion.
If set to \code{NULL} the first criterion wont be applied.}

\item{sg_crit2_pct}{Numeric, specifying the percentage change to be used for the second sudden gains/losses criterion.
If set to \code{NULL} the second criterion wont be applied.}

\item{sg_crit3}{If set to \code{TRUE} the third criterion will be applied automatically adjusting the critical value for missingness.
If set to \code{FALSE} the third criterion wont be applied.}

\item{sg_crit3_alpha}{Numeric, alpha for the student t-test (two-tailed) to determine the critical value to be used for the third criterion.
Degrees of freedom are based on the number of available data in the three sessions preceding the gain and the three sessions following the gain.}

\item{identify}{String, specifying whether to identify sudden gains (\code{"sg"}) or sudden losses (\code{"sl"}).}

\item{details}{Logical, details yes no?}
}
\value{
Information on whether a given interval is a sudden gain/loss
}
\description{
Checks if a given interval is a sudden gain/loss
}
\examples{
# Check interval for sudden gain using all 3 criteria
# No missing data, alpha = 0.05
check_interval(pre_values = c(32, 31, 33),
               post_values = c(5, 6, 7),
               sg_crit1_cutoff = 7,
               sg_crit2_pct = .25,
               sg_crit3 = TRUE,
               sg_crit3_alpha = .05,
               identify = "sg")

# No missing data, alpha = 0.01
check_interval(pre_values = c(32, 31, 33),
               post_values = c(5, 6, 7),
               sg_crit1_cutoff = 7,
               sg_crit2_pct = .25,
               sg_crit3 = TRUE,
               sg_crit3_alpha = .01,
               identify = "sg")

# Check intervall for sudden gain using only third criterion
# Some missing data, alpha = 0.01
check_interval(pre_values = c(NA,31,33),
               post_values = c(5, NA, 7),
               sg_crit1_cutoff = NULL,
               sg_crit2_pct = NULL,
               sg_crit3 = TRUE,
               sg_crit3_alpha = .01,
               identify = "sg")

# Check intervall for sudden loss using all three criteria
# Some missing data, alpha = 0.05
check_interval(pre_values = c(5, NA, 7),
               post_values = c(16, 12, 14),
               sg_crit1_cutoff = -7,
               sg_crit2_pct = .25,
               sg_crit3 = TRUE,
               sg_crit3_alpha = .05,
               identify = "sl")

}
