% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sunriset.R
\name{sunriset}
\alias{sunriset}
\alias{sunriset,sf,POSIXct-method}
\alias{sunriset,matrix,POSIXct-method}
\alias{sunriset,SpatialPoints,POSIXct-method}
\title{Calculate sunrise/sunset}
\usage{
sunriset(crds, dateTime, ...)

\S4method{sunriset}{sf,POSIXct}(
  crds,
  dateTime,
  direction = c("sunrise", "sunset"),
  POSIXct.out = FALSE
)

\S4method{sunriset}{matrix,POSIXct}(
  crds,
  dateTime,
  crs = sf::st_crs(4326),
  direction = c("sunrise", "sunset"),
  POSIXct.out = FALSE
)

\S4method{sunriset}{SpatialPoints,POSIXct}(
  crds,
  dateTime,
  direction = c("sunrise", "sunset"),
  POSIXct.out = FALSE
)
}
\arguments{
\item{crds}{Geographical coordinates. It can be an object of
class \code{sf}, \code{matrix}, or \code{SpatialPoints}.}

\item{dateTime}{A \code{POSIXct} object representing the date and time.}

\item{...}{Additional arguments that are passed to methods.}

\item{direction}{Character, determines whether to calculate the time of sunrise or sunset.}

\item{POSIXct.out}{Logical, if \code{TRUE}, the result is returned as a \code{POSIXct} object, otherwise, it is returned as a fraction of a day.}

\item{crs}{A "CRS" object representing the coordinate reference system.
Default is \code{sf::st_crs(4326)} which denotes WGS84 (World Geodetic System 1984).}
}
\value{
data.frame with the time of sunrise as a fraction of a day; if POSIXct.out=TRUE returns an additional
POSIXct timestamp column (default = TRUE)
}
\description{
Calculates sunrise or sunset at a specific geographical location and time
depending on the \code{direction} parameter.
}
\details{
Methods are available for different classes of geographical coordinates, including:
\itemize{
\item \code{sf}: an object of class \code{sf}.
\item \code{matrix}: An unnamed matrix of coordinates, with each row containing a pair of geographical coordinates in \code{c(lon, lat)} order. See the example below.
\item \code{SpatialPoints}: an object of class \code{SpatialPoints}.
Input can consist of one location and at least one \code{POSIXct} time, or one \code{POSIXct}
time and at least one location. \code{solarDep} is recycled as needed.
Do not use the daylight savings time zone string for supplying \code{dateTime}, as many OS
will not be able to properly set it to standard time when needed.
}

Compared to NOAA’s original Javascript code, the sunrise and sunset estimates from this translation
may differ by +/- 1 minute, based on tests using selected locations spanning the globe.
This translation does not include calculation of prior or next sunrises/sunsets for locations above the Arctic
Circle or below the Antarctic Circle.
\subsection{Solar position calculation}{

Details for the calculations are provided by NOAA \href{https://gml.noaa.gov/grad/solcalc/calcdetails.html}{here},
which we repeat below as a reference.

The calculations in the NOAA Sunrise/Sunset and Solar Position Calculators are based on equations
from Astronomical Algorithms, by Jean Meeus. The sunrise and sunset results are theoretically accurate
to within a minute for locations between +/- 72° latitude, and within 10 minutes outside of those latitudes.
However, due to variations in atmospheric composition, temperature, pressure and conditions, observed values may vary from calculations.

For the purposes of these calculators the current Gregorian calendar is extrapolated backward through time.
When using a date before 15 October, 1582, you will need to correct for this. The year preceding year 1 in
the calendar is year zero (0). The year before that is -1. The approximations used in these programs are very
good for years between 1800 and 2100. Results should still be sufficiently accurate for the range
from -1000 to 3000. Outside of this range, results may be given, but the potential for error is higher.
}

\subsection{Atmospheric refraction correction}{

For sunrise and sunset calculations, we assume 0.833° of atmospheric refraction.
In the solar position calculator, atmospheric refraction is modeled as:\tabular{ll}{
   Solar Elevation \tab Approximate Atmospheric Refraction Correction (°) \cr
   85° to 90° \tab 0 \cr
   5° to 85° \tab \eqn{\frac{1}{3600}\left(\frac{58.1}{\tan(h)} - \frac{0.07}{\tan^3(h)} + \frac{0.000086}{\tan^5(h)}\right)} \cr
   -0.575° to 5° \tab \eqn{\frac{1}{3600}\left(1735 - 518.2 h + 103.4 h^2 - 12.79 h^3 + 0.711 h^4\right)} \cr
   < -0.575° \tab \eqn{\frac{1}{3600}\left(\frac{-20.774}{\tan(h)}\right)} \cr
}


The effects of the atmosphere vary with atmospheric pressure, humidity and other variables.
Therefore the solar position calculations presented here are approximate. Errors in sunrise
and sunset times can be expected to increase the further away you are from the equator,
because the sun rises and sets at a very shallow angle. Small variations in the atmosphere
can have a larger effect.
}
}
\examples{
#Sunset in Ithaca, NY, USA on June 1, 2023

sunriset(
 matrix(c(-76.4511, 42.4800), nrow = 1),
 as.POSIXct("2023-06-01", tz = "America/New_York"),
 direction='sunset',
 POSIXct.out=TRUE
)
}
\references{
\itemize{
\item Meeus, J. (1991) Astronomical Algorithms. Willmann-Bell, Inc.
\item NOAA's \href{https://gml.noaa.gov/grad/solcalc/sunrise.html}{sunrise/sunset calculator}.
These algorithms include corrections for atmospheric refraction effects.
\item NOAA's \href{https://gml.noaa.gov/grad/solcalc/calcdetails.html}{solar calculations details}
}
}
