% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LabelEncoder.R
\docType{data}
\name{LabelEncoder}
\alias{LabelEncoder}
\title{Label Encoder}
\format{\code{\link{R6Class}} object.}
\usage{
LabelEncoder
}
\description{
Encodes and decodes categorical variables into integer values and vice versa.
This is a commonly performed task in data preparation during model training, because all machine learning models require
the data to be encoded into numerical format. It takes a vector of character or factor values and encodes them into numeric.
}
\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
lbl = LabelEncoder$new()
lbl$fit(x)
lbl$fit_transform(x)
lbl$transform(x)
}
}

\section{Methods}{

\describe{
  \item{\code{$new()}}{Initialise the instance of the encoder}
  \item{\code{$fit()}}{creates a memory of encodings but doesn't return anything}
  \item{\code{$transform()}}{based on encodings learned in \code{fit} method is applies the transformation}
  \item{\code{$fit_transform()}}{encodes the data and keep a memory of encodings simultaneously}
  \item{\code{$inverse_transform()}}{encodes the data and keep a memory of encodings simultaneously}
}
}

\section{Arguments}{

\describe{
 \item{LabelEncoder}{A \code{LabelEncoder} object}
 \item{data}{a vector or list containing the character / factor values}
}
}

\examples{
data_ex <- data.frame(Score = c(10,20,30,4), Name=c('Ao','Bo','Bo','Co'))
lbl <- LabelEncoder$new()
data_ex$Name <- lbl$fit_transform(data_ex$Name)
decode_names <- lbl$inverse_transform(data_ex$Name)
}
\keyword{datasets}
