% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GridSearch.R
\docType{data}
\name{GridSearchCV}
\alias{GridSearchCV}
\title{Grid Search CV}
\format{\code{\link{R6Class}} object.}
\usage{
GridSearchCV
}
\description{
Grid search CV is used to train a machine learning model with multiple combinations
of training hyper parameters and finds the best combination of parameters which optimizes the evaluation metric.
It creates an exhaustive set of hyperparameter combinations and train model on each combination.
}
\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
gst = GridSearchTrainer$new(trainer, parameters, n_folds, scoring)
gst$fit(X, y)
gst$best_iteration(metric)
}
}

\section{Methods}{

\describe{
  \item{\code{$new()}}{Initialises an instance of grid search cv}
  \item{\code{$fit()}}{fit model to an input train data and trains the model.}
  \item{\code{$best_iteration()}}{returns best iteration based on a given metric. By default, uses the first scoring metric}
}
}

\section{Arguments}{

\describe{
 \item{trainer}{superml trainer object, could be either XGBTrainer, RFTrainer, NBTrainer etc.}
 \item{parameters}{list containing parameters}
 \item{n_folds}{number of folds to use to split the train data}
 \item{scoring}{scoring metric used to evaluate the best model, multiple values can be provided.
               currently supports: auc, accuracy, mse, rmse, logloss, mae, f1, precision, recall}
}
}

\examples{
rf <- RFTrainer$new()
gst <-GridSearchCV$new(trainer = rf,
                      parameters = list(n_estimators = c(100),
                                        max_depth = c(5,2,10)),
                                        n_folds = 3,
                                        scoring = c('accuracy','auc'))
data("iris")
gst$fit(iris, "Species")
gst$best_iteration()
}
\keyword{datasets}
