% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_models.R
\name{generate_models}
\alias{generate_models}
\title{Generate a List of Models for Computing Different Types of Sums of Squares}
\usage{
generate_models(model, type)
}
\arguments{
\item{model}{The model to generate the models from, of the type
\code{\link{lm}}, \code{\link{aov}}, or \code{\link{formula}}.}

\item{type}{The type of sums of squares to calculate:
\itemize{
  \item Use \code{1}, \code{I}, and \code{sequential} for Type I.
  \item Use \code{2}, \code{II}, and \code{hierarchical} for Type II.
  \item Use \code{3}, \code{III}, and \code{orthogonal} for Type III.
}}
}
\value{
A list of the augmented models for each term, where the associated
  term is the key for each model in the list.
}
\description{
This function will return a list of lists where the top-level keys (names) of
the items indicate the component of the full model (i.e. the term) that the
generated models can be used to test. At each of these keys is a list with
both the \code{complex} and \code{simple} models that can be compared to test
the component. The \code{complex} models always include the target term, and
the \code{simple} models are identical to the \code{complex} except the
target term is removed. Thus, when the models are compared (e.g. using
\code{\link{anova}}, except for Type III; see details below), the resulting
values will show the effect of adding the target term to the model. There are
three generally used approaches to determining what the appropriate
comparison models should be, called Type I, II, and III. See the sections
below for more information on these types.
}
\section{Type I}{
 For Type I SS, or sequential SS, each term is considered in
  order after the preceding terms are considered. Consider the example model
  \code{Y ~ A + B + A:B}, where ":" indicates an interaction. To determine
  the Type I effect of \code{A}, we would compare the model \code{Y ~ A} to
  the same model without the term: \code{Y ~ NULL}. For \code{B}, we compare
  \code{Y ~ A + B} to \code{Y ~ A}; and for \code{A:B}, we compare \code{Y ~
  A + B + A:B} to \code{Y ~ A + B}. Incidentally, the \code{\link{anova}}
  function that ships with the base installation of R computes Type I
  statistics.
}

\section{Type II}{
 For Type II SS, or hierarchical SS, each term is considered
  in the presence of all of the terms that do not include it. For example,
  consider an example three-way factorial model \code{Y ~ A + B + C + A:B +
  A:C + B:C + A:B:C}, where ":" indicates an interaction. The effect of
  \code{A} is found by comparing \code{Y ~ B + C + B:C + A} to \code{Y ~ B +
  C + B:C} (the only terms included are those that do not include \code{A}).
  For \code{B}, the comparison models would be \code{Y ~ A + C + A:C + B} and
  \code{Y ~ A + C + A:C}; for \code{A:B}, the models would be \code{Y ~ A + B
  + C + A:C + B:C + A:B} and \code{Y ~ A + B + C + A:C + B:C}; and so on.
}

\section{Type III}{
 For Type III SS, or orthogonal SS, each term is considered
  in the presence of all of the other terms. For example, consider an example
  two-way factorial model \code{Y ~ A + B + A:B}, where ":" indicates an
  interaction. The effect of \code{A} is found by comparing \code{Y ~ B + A:B
  + A} to  \code{Y ~ B + A:B}; for \code{B}, the comparison models would be
  \code{Y ~ A + A:B + B} and \code{Y ~ A + A:B}; and for \code{A:B}, the
  models would be \code{Y ~ A + B + A:B} and \code{Y ~ A + B}.

  Unfortunately, \code{\link{anova}()} cannot be used to compare Type III
  models. \code{anova()} does not allow for violation of the principle of
  marginality, which is the rule that interactions should only be tested in
  the context of their lower order terms. When an interaction term is present
  in a model, \code{anova()} will automatically add in the lower-order terms,
  making a model like \code{Y ~ A + A:B} unable to be compared: it will add
  the lower-order term \code{B},and thus use the model \code{Y ~ A + B + A:B}
  instead. To get the appropriate statistics for Type III comparisons, use
  \code{\link{drop1}()} with the full scope, i.e. \code{drop1(model_fit,
  scope = . ~ .)}.
}

\examples{
# create all type 2 comparison models
mod <- lm(Thumb ~ Height * Sex, data = Fingers)
mods_2 <- generate_models(mod, type = 2)

# compute the SS for the Height term
mod_Height <- anova(mods_2[["Height"]]$simple, mods_2[["Height"]]$complex)
mod_Height[["Sum of Sq"]][[2]]

}
