% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_table.R
\name{summary_table}
\alias{summary_table}
\title{Generate Summary Table for Supplied Response and Grouping Variables}
\usage{
summary_table(
  data = NULL,
  groups = NULL,
  response = NULL,
  drop_na = FALSE,
  round_digits = 2
)
}
\arguments{
\item{data}{(dataframe or dataframe-like) object with column names that match the values passed to the \code{groups} and \code{response} arguments}

\item{groups}{(character) vector of column names to group by}

\item{response}{(character) name of the column name to calculate summary statistics for (the column must be numeric)}

\item{drop_na}{(logical) whether to drop NAs in grouping variables. Defaults to FALSE}

\item{round_digits}{(numeric) number of digits to which mean, standard deviation, and standard error should be rounded}
}
\value{
(dataframe) summary table containing the mean, standard deviation, sample size, and standard error of the supplied response variable)
}
\description{
Calculates mean, standard deviation, sample size, and standard error of a given response variable within user-defined grouping variables. This is meant as a convenience instead of doing \code{dplyr::group_by} followed by \code{dplyr::summarize} iteratively themselves.
}
