% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github_tree.R
\name{github_tree}
\alias{github_tree}
\title{Create File Tree of a GitHub Repository}
\usage{
github_tree(repo = NULL, exclude = NULL, quiet = FALSE)
}
\arguments{
\item{repo}{(character) full URL for a github repository (including "github.com")}

\item{exclude}{(character) vector of folder names to exclude from the file tree. If \code{NULL} (the default) no folders are excluded}

\item{quiet}{(logical) whether to print an informative message as the contents of each folder is being listed and as the tree is prepared from that information}
}
\value{
(node / R6) \code{data.tree} package object class
}
\description{
Recursively identifies all files in a GitHub repository and creates a file tree using the \code{data.tree} package to create a simple, human-readable visualization of the folder hierarchy. Folders can be specified for exclusion in which case the number of elements within them is listed but not the names of those objects. This function only works on repositories (public or private) to which you have access.
}
\examples{
\dontrun{
# Create a file tree for the `supportR` package GitHub repository
github_tree(repo = "github.com/njlyon0/supportR", exclude = c("man", "docs", ".github"))
}

}
