% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/force_num.R
\name{force_num}
\alias{force_num}
\title{Force Coerce to Numeric}
\usage{
force_num(x = NULL)
}
\arguments{
\item{x}{(non-numeric) vector containing elements to be coerced into class numeric}
}
\value{
(numeric) vector of numeric values
}
\description{
Coerces a vector into a numeric vector and automatically silences \verb{NAs introduced by coercion} warning. Useful for cases where non-numbers are known to exist in vector and their coercion to NA is expected / unremarkable. Essentially just a way of forcing this coercion more succinctly than wrapping \code{as.numeric} in \code{suppressWarnings}.
}
\examples{
# Coerce a character vector to numeric without throwing a warning
force_num(x = c(2, "A", 4))
}
