% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{build_surmodel}
\alias{build_surmodel}
\title{Build an surmodel object}
\usage{
build_surmodel(fn, n_in, d_in, doe_type = "rlhs", sur_type = "mkm",
  pre_process = NULL, post_process = NULL)
}
\arguments{
\item{fn}{high fidelity function (fun must return a list of vectors with the
format list(y = c(y1, y2, y3), g = c(g1, g2))).
Alternatively, it can e a data.frame with names such as X.1, X.2, Y.1, G.1, G.2, G3}

\item{n_in, d_in}{integer number of observations and dimension of the input variables}

\item{doe_type}{string that defines the doe generation scheme (list valid schemes)}

\item{sur_type}{string that defines the surogate type (list valid types)}

\item{pre_process}{string vector defining the pre processing functions}

\item{post_process}{string vector defining the post processing}
}
\value{
surogate model
}
\description{
Build an surmodel object
}
\examples{

fn <- function(x) list(y = x^2)
model <- build_surmodel(fn, 20, 1)

fn <- function(x) list(y = DiceKriging::branin(x))
model <- build_surmodel(fn, 20, 2)

fn <- function(x) list(y = DiceKriging::branin(x), g = 0.2 - prod(x))
model <- build_surmodel(fn, 20, 2)

fn <- shaffer2
model <- build_surmodel(fn, 20, 1)

fn <- binh
model <- build_surmodel(fn, 20, 2)

data <- data.frame(X.1 = runif(5), X.2 = runif(5), Y.1 = runif(5))
model <- build_surmodel(data)

data <- data.frame(X.1 = runif(5), X.2 = runif(5), Y.1 = runif(5), G.1 = rnorm(5))
model <- build_surmodel(data)
}
