% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_survcompare.R, R/survcompare.R
\docType{package}
\name{survcompare}
\alias{survcompare}
\title{Cross-validates and compares Cox Proportionate Hazards and Survival Random Forest models}
\usage{
survcompare(
  df_train,
  predict_factors,
  predict_time = NULL,
  randomseed = NULL,
  useCoxLasso = FALSE,
  outer_cv = 3,
  inner_cv = 3,
  srf_tuning = list(),
  return_models = FALSE,
  repeat_cv = 2,
  train_srf = FALSE
)
}
\arguments{
\item{df_train}{training data, a data frame with "time" and "event" columns to define the survival outcome}

\item{predict_factors}{list of column names to be used as predictors}

\item{predict_time}{prediction time of interest. If NULL, 0.90th quantile of event times is used}

\item{randomseed}{random seed for replication}

\item{useCoxLasso}{TRUE / FALSE, for whether to use regularized version of the Cox model, FALSE is default}

\item{outer_cv}{k in k-fold CV}

\item{inner_cv}{k in k-fold CV for internal CV to tune survival random forest hyper-parameters}

\item{srf_tuning}{list of tuning parameters for random forest: 1) NULL for using a default tuning grid, or 2) a list("mtry"=c(...), "nodedepth" = c(...), "nodesize" = c(...))}

\item{return_models}{TRUE/FALSE to return the trained models; default is FALSE, only performance is returned}

\item{repeat_cv}{if NULL, runs once, otherwise repeats several times with different random split for CV, reports average of all}

\item{train_srf}{TRUE/FALSE for whether to train SRF on its own, apart from the CoxPH->SRF ensemble. Default is FALSE as there is not much information in SRF itself compared to the ensembled version.}
}
\value{
outcome = list(data frame with performance results, fitted Cox models, fitted SRF)
}
\description{
The function performs a repeated nested cross-validation for
\enumerate{
\item Cox-PH (survival package, survival::coxph) or Cox-Lasso (glmnet package, glmnet::cox.fit)
\item Ensemble of the Cox model and Survival Random Forest (randomForestSRC::rfsrc)
\item Survival Random Forest on its own, if train_srf = TRUE
}

The same random seed for the train/test splits are used for all models to aid fair comparison;
and the performance metrics are computed for the tree models including Harrel's c-index,
time-dependent AUC-ROC, time-dependent Brier Score, and calibration slope.
The statistical significance of the performance differences between Cox-PH and Cox-SRF Ensemble is tested and reported.

The function is designed to help with the model selection by quantifying the loss of predictive
performance (if any) if Cox-PH is used instead of a more complex model such as SRF
which can capture non-linear and interaction terms, as well as non-proportionate hazards.
The difference in performance of the Ensembled Cox and SRF and the baseline Cox-PH
can be viewed as quantification of the non-linear and cross-terms contribution to
the predictive power of the supplied predictors.

Cross-validates and compares Cox Proportionate Hazards and Survival Random Forest models
}
\examples{
\dontshow{rfcores_old <- options()$rf.cores; options(rf.cores=1)}
df <-simulate_nonlinear(100)
srf_params <- list("mtry" = c(2), "nodedepth"=c(25), "nodesize" =c(15))
mysurvcomp <- survcompare(df, names(df)[1:4], srf_tuning = srf_params, outer_cv = 2, inner_cv =2)
summary(mysurvcomp)
\dontshow{options(rf.cores=rfcores_old)}
}
\author{
Diana Shamsutdinova \email{diana.shamsutdinova.github@gmail.com}
}
