% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{explain}
\alias{explain}
\alias{explain.default}
\alias{explain_survival}
\alias{explain.coxph}
\alias{explain.ranger}
\alias{explain.rfsrc}
\alias{explain.model_fit}
\alias{explain.LearnerSurv}
\title{A model agnostic explainer for survival models}
\usage{
explain(
  model,
  data = NULL,
  y = NULL,
  predict_function = NULL,
  predict_function_target_column = NULL,
  residual_function = NULL,
  weights = NULL,
  ...,
  label = NULL,
  verbose = TRUE,
  colorize = !isTRUE(getOption("knitr.in.progress")),
  model_info = NULL,
  type = NULL
)

\method{explain}{default}(
  model,
  data = NULL,
  y = NULL,
  predict_function = NULL,
  predict_function_target_column = NULL,
  residual_function = NULL,
  weights = NULL,
  ...,
  label = NULL,
  verbose = TRUE,
  colorize = !isTRUE(getOption("knitr.in.progress")),
  model_info = NULL,
  type = NULL
)

explain_survival(
  model,
  data = NULL,
  y = NULL,
  predict_function = NULL,
  predict_function_target_column = NULL,
  residual_function = NULL,
  weights = NULL,
  ...,
  label = NULL,
  verbose = TRUE,
  colorize = !isTRUE(getOption("knitr.in.progress")),
  model_info = NULL,
  type = NULL,
  times = NULL,
  times_generation = "quantiles",
  predict_survival_function = NULL,
  predict_cumulative_hazard_function = NULL
)

\method{explain}{coxph}(
  model,
  data = NULL,
  y = NULL,
  predict_function = NULL,
  predict_function_target_column = NULL,
  residual_function = NULL,
  weights = NULL,
  ...,
  label = NULL,
  verbose = TRUE,
  colorize = !isTRUE(getOption("knitr.in.progress")),
  model_info = NULL,
  type = NULL,
  times = NULL,
  times_generation = "quantiles",
  predict_survival_function = NULL,
  predict_cumulative_hazard_function = NULL
)

\method{explain}{ranger}(
  model,
  data = NULL,
  y = NULL,
  predict_function = NULL,
  predict_function_target_column = NULL,
  residual_function = NULL,
  weights = NULL,
  ...,
  label = NULL,
  verbose = TRUE,
  colorize = !isTRUE(getOption("knitr.in.progress")),
  model_info = NULL,
  type = NULL,
  times = NULL,
  times_generation = "quantiles",
  predict_survival_function = NULL,
  predict_cumulative_hazard_function = NULL
)

\method{explain}{rfsrc}(
  model,
  data = NULL,
  y = NULL,
  predict_function = NULL,
  predict_function_target_column = NULL,
  residual_function = NULL,
  weights = NULL,
  ...,
  label = NULL,
  verbose = TRUE,
  colorize = !isTRUE(getOption("knitr.in.progress")),
  model_info = NULL,
  type = NULL,
  times = NULL,
  times_generation = "quantiles",
  predict_survival_function = NULL,
  predict_cumulative_hazard_function = NULL
)

\method{explain}{model_fit}(
  model,
  data = NULL,
  y = NULL,
  predict_function = NULL,
  predict_function_target_column = NULL,
  residual_function = NULL,
  weights = NULL,
  ...,
  label = NULL,
  verbose = TRUE,
  colorize = !isTRUE(getOption("knitr.in.progress")),
  model_info = NULL,
  type = NULL,
  times = NULL,
  times_generation = "quantiles",
  predict_survival_function = NULL,
  predict_cumulative_hazard_function = NULL
)

\method{explain}{LearnerSurv}(
  model,
  data = NULL,
  y = NULL,
  predict_function = NULL,
  predict_function_target_column = NULL,
  residual_function = NULL,
  weights = NULL,
  ...,
  label = NULL,
  verbose = TRUE,
  colorize = !isTRUE(getOption("knitr.in.progress")),
  model_info = NULL,
  type = NULL,
  times = NULL,
  times_generation = "quantiles",
  predict_survival_function = NULL,
  predict_cumulative_hazard_function = NULL
)
}
\arguments{
\item{model}{object - a survival model to be explained}

\item{data}{data.frame - data which will be used to calculate the explanations. If not provided, then it will be extracted from the model if possible. It should not contain the target columns. NOTE: If the target variable is present in the \code{data} some functionality breaks.}

\item{y}{\code{survival::Surv} object containing event/censoring times and statuses corresponding to \code{data}}

\item{predict_function}{function taking 2 arguments - \code{model} and \code{newdata} and returning a single number for each observation - risk score. Observations with higher score are more likely to observe the event sooner.}

\item{predict_function_target_column}{unused, left for compatibility with DALEX}

\item{residual_function}{unused, left for compatibility with DALEX}

\item{weights}{unused, left for compatibility with DALEX}

\item{...}{additional arguments, passed to \code{DALEX::explain()}}

\item{label}{character - the name of the model. Used to differentiate on visualizations with multiple explainers. By default it's extracted from the 'class' attribute of the model if possible.}

\item{verbose}{logical, if TRUE (default) then diagnostic messages will be printed}

\item{colorize}{logical, if TRUE (default) then WARNINGS, ERRORS and NOTES are colorized. Will work only in the R console. By default it is FALSE while knitting and TRUE otherwise.}

\item{model_info}{a named list (\code{package}, \code{version}, \code{type}) containing information about model. If \code{NULL}, \code{survex} will seek for information on its own.}

\item{type}{type of a model, by default \code{"survival"}}

\item{times}{numeric, a vector of times at which the survival function and cumulative hazard function should be evaluated for calculations}

\item{times_generation}{either \code{"uniform"} or \code{"quantiles"}. Sets the way of generating the vector of times based on times provided in the \code{y} parameter. If \code{"uniform"} the vector contains 101 equally spaced points between the minimum and maximum observed times; if \code{"quantiles"} the vector contains 100 points between 0th and 99th percentiles of observed times. Ignored if \code{times} is not \code{NULL}.}

\item{predict_survival_function}{function taking 3 arguments \code{model}, \code{newdata} and \code{times}, and returning a matrix whose each row is a survival function evaluated at \code{times} for one observation from \code{newdata}}

\item{predict_cumulative_hazard_function}{function taking 3 arguments \code{model}, \code{newdata} and \code{times}, and returning a matrix whose each row is a cumulative hazard function evaluated at \code{times} for one observation from \code{newdata}}
}
\value{
It is a list containing the following elements:
\itemize{
\item \code{model} - the explained model.
\item \code{data} - the dataset used for training.
\item \code{y} - response for observations from \code{data}.
\item \code{residuals} - calculated residuals.
\item \code{predict_function} - function that may be used for model predictions, shall return a single numerical value for each observation.
\item \code{residual_function} - function that returns residuals, shall return a single numerical value for each observation.
\item \code{class} - class/classes of a model.
\item \code{label} - label of explainer.
\item \code{model_info} - named list contating basic information about model, like package, version of package and type.
\item \code{times} - a vector of times, that are used for evaluation of survival function and cumulative hazard function by default
\item \code{predict_survival_function} - function that is used for model predictions in the form of survival function
\item \code{predict_cumulative_hazard_function} - function that is used for model predictions in the form of cumulative hazard function
}
}
\description{
Black-box models have vastly different structures. \code{explain_survival()}
returns an object which can be further processed for creating prediction
explanations and their visualizations.
}
\details{
This function can be used manually to create explainers for models which
are not covered by the \code{survex} package.
}
\examples{
\donttest{
library(survival)
library(survex)

cph <- survival::coxph(survival::Surv(time, status) ~ ., data = veteran,
                       model = TRUE, x = TRUE)
cph_exp <- explain(cph)

rsf_ranger <- ranger::ranger(survival::Surv(time, status) ~ ., data = veteran,
 respect.unordered.factors = TRUE, num.trees = 100, mtry = 3, max.depth = 5)
rsf_ranger_exp <- explain(rsf_ranger, data = veteran[, -c(3, 4)],
 y = Surv(veteran$time, veteran$status))

rsf_src <- randomForestSRC::rfsrc(Surv(time, status) ~ ., data = veteran)
rsf_src_exp <- explain(rsf_src)

library(censored, quietly = TRUE)

bt <- parsnip::boost_tree() \%>\%
   parsnip::set_engine("mboost") \%>\%
   parsnip::set_mode("censored regression") \%>\%
   generics::fit(survival::Surv(time, status) ~ ., data = veteran)
bt_exp <- explain(bt, data = veteran[, -c(3, 4)], y = Surv(veteran$time, veteran$status))
}
}
