% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db.R
\name{sd_get_data}
\alias{sd_get_data}
\title{Fetch data from a database table with automatic reactivity detection}
\usage{
sd_get_data(db, table = NULL, refresh_interval = NULL)
}
\arguments{
\item{db}{A list containing database connection details created using
\code{sd_db_config()}. Must have elements:
\itemize{
\item \code{db}: A \code{DBI} database connection object
\item \code{table}: A string specifying the name of the table to query
}}

\item{table}{Character string. Database table name to obtain data from,
overrides the table provided in the \code{db} argument. Defaults to \code{NULL}.}

\item{refresh_interval}{Numeric. The time interval (in seconds) between data
refreshes when in a reactive context. Default is \code{NULL}, meaning the data
will not refresh.}
}
\value{
In a non-reactive context, returns a data frame containing all rows
and columns from the specified table. In a reactive context, returns a
reactive expression that, when called, returns the most recent data from
the specified database table.
}
\description{
This function retrieves all data from a specified table in a database.
It automatically detects whether it's being used in a reactive context
(e.g., within a 'shiny' application) and behaves accordingly. In a reactive
context, it returns a reactive expression that automatically refreshes
the data at specified intervals.
}
\examples{
# Non-reactive context example
\dontrun{
  library(surveydown)

  # Assuming you have a database connection called db created using
  # sd_database(), you can fetch data with:

  data <- sd_get_data(db)
  head(data)

  # Reactive context example (inside a surveydown app)

  server <- function(input, output, session) {
    data <- sd_get_data(db, refresh_interval = 10)

    output$data_table <- renderTable({
      data()  # Note the parentheses to retrieve the reactive value
    })
  }
}
}
