% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeOutliers.R
\name{removeOutliers}
\alias{removeOutliers}
\title{Calculate outliers in a numeric vector and then convert those values to NA}
\usage{
removeOutliers(x, tolerant = TRUE)
}
\arguments{
\item{x}{A numeric vector}

\item{tolerant}{Outlier calculation tolerance. A more tolerant outlier 
removal is more appropriate when working with hazard ratios}
}
\value{
The modified, outlier removed, equivalent of x
}
\description{
Calculate outliers in a numeric vector and then convert those values to NA
}
\examples{
set.seed(123); x <- rnorm(100)
sum(is.na(x))
y <- removeOutliers(x)
sum(is.na(y))
}
