% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cox.R
\name{pluck_multivariate_analysis}
\alias{pluck_multivariate_analysis}
\title{Access individual components of multivariate survival analysis}
\usage{
pluck_multivariate_analysis(result, term)
}
\arguments{
\item{result}{An object of class SurvivalAnalysisMultivariateResult
as returned by \code{\link{analyse_multivariate}}}

\item{term}{The item to be retrieved:
\itemize{
  \item \code{"coxph"} containing the result of the \code{\link{coxph}} function
  \item \code{"summary"} containing the result of the \code{\link{summary}} of the "coxph" result
  \item \code{"summary_data_frame"} containing summary as a data frame (see \code{\link{multivariate_as_data_frame}})
  \item \code{"p"} A vector of p values for the covariates, equivalent to the "p" column of "summary_data_frame"
  \item \code{"overall"} A named list with human-readable labels giving information about the overall fit,
                         including the three flavors of p values contained in "summary"
}}
}
\value{
object as specified by \code{term}, or NULL if not contained in \code{result}
}
\description{
Allows access to the \code{\link{analyse_multivariate}} result object.
}
\examples{
library(magrittr)
library(dplyr)
survival::colon \%>\%
   analyse_multivariate(vars(time, status),
                        vars(rx, sex, age, obstruct, perfor, nodes, differ, extent)) \%>\%
   pluck_multivariate_analysis("p")
   print
}
