% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictions.R
\name{predict.survivalsvm}
\alias{predict.survivalsvm}
\title{Suvirvalsvm predictions}
\usage{
\method{predict}{survivalsvm}(object, newdata, subset = NULL, ...)
}
\arguments{
\item{object}{[\code{survivalsvm(1)}]\cr
Object of class \code{survivalsvm}, fitted with \code{\link{survivalsvm}}.}

\item{newdata}{[\code{data.frame(1)}]\cr
Data frame of observations.}

\item{subset}{[\code{vector(1)}]\cr
Indexes of data points of used to make the prediction.}

\item{...}{[\code{any}]\cr
Further arguments passed to or from other methods.}
}
\value{
[\code{survivalsvmprediction(1)}]
Object of class \code{survivalsvmprediction}, with elements:
\tabular{ll}{
   \code{typeofsurvivalsvm} \tab Type of  \code{survivalsvm} object that is fitted in the model, \cr
   \code{typeofkernel} \tab type of kernel used to fit the model,\cr
   \code{parameterofkernel} \tab Kernel parameters used to fit the model,\cr
   \code{opt.meth} \tab solver used to fit the model,\cr
   \code{predicted} \tab values predicted.\cr
 }
}
\description{
Predictions of objects of class \code{survivalsvm}.
}
\examples{
require(survival)
set.seed(123)
n <- nrow(veteran)
train.index <- sample(1:n, 0.7*n, replace = FALSE)
test.index <- setdiff(1:n, train.index)
survsvm.reg <- survivalsvm(Surv(veteran$diagtime, veteran$status) ~ .,
                           subset = train.index, data = veteran,
                           type = "regression", gamma.mu = 1,
                           opt.meth = "quadprog", kernel = "add_kernel")
pred.survsvm.reg <- predict(object = survsvm.reg, newdata = veteran, subset = test.index)
print(pred.survsvm.reg)
}
\seealso{
\link{survivalsvm}
}
\author{
Cesaire J. K. Fouodo
}
