% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_time.R
\name{cross_time.ypreg}
\alias{cross_time.ypreg}
\title{Computes the crossing survival times}
\usage{
\method{cross_time}{ypreg}(object, newdata1, newdata2, conf.level = 0.95, nboot = 1000, ...)
}
\arguments{
\item{object}{an object of class ypreg}

\item{newdata1}{a data frame containing the first set of explanatory variables}

\item{newdata2}{a data frame containing the second set of explanatory variables}

\item{conf.level}{level of the confidence/credible intervals}

\item{nboot}{number of bootstrap samples (default nboot=1000).}

\item{...}{further arguments passed to or from other methods.}
}
\value{
the crossing survival time
}
\description{
Computes the crossing survival times
}
\examples{
\donttest{
library(survstan)
data(ipass)
fit <- ypreg(Surv(time, status)~arm, data=ipass, baseline = "weibull")
summary(fit)
newdata1 <- data.frame(arm=0)
newdata2 <- data.frame(arm=1)
tcross <- cross_time(fit, newdata1, newdata2, nboot = 10)
tcross
}

}
