% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlg_input.R
\name{dlg_input}
\alias{dlg_input}
\alias{dlgInput}
\alias{dlgInput.gui}
\alias{dlgInput.textCLI}
\alias{dlgInput.nativeGUI}
\title{Modal dialog to input a string or a value.}
\usage{
dlg_input(message = "Enter a value", default = "", ..., gui = .GUI)

dlgInput(message = "Enter a value", default = "", ..., gui = .GUI)

\method{dlgInput}{gui}(message = "Enter a value", default = "", ..., gui = .GUI)

\method{dlgInput}{textCLI}(message = "Enter a value", default = "", ..., gui = .GUI)

\method{dlgInput}{nativeGUI}(
  message = "Enter a value",
  default = "",
  rstudio = getOption("svDialogs.rstudio", TRUE),
  ...,
  gui = .GUI
)
}
\arguments{
\item{message}{The message to display in the dialog box. Use \verb{\\\\n} for
line break, or provide a vector of character strings, one for each line.}

\item{default}{The default value in the text box. Single string or \code{NULL}.}

\item{...}{Pass further arguments to methods.}

\item{gui}{The 'gui' object concerned by this dialog box.}

\item{rstudio}{Logical. Should 'RStudio' dialog boxes automatically be used
if available? If \code{FALSE}, force using OS dialog boxes, but only in
'RStudio Desktop' (ignored in 'RStudio Server'). Can be changed globally
with \code{options(svDialogs.rstudio = TRUE|FALSE)}. \code{TRUE} by default.}
}
\value{
The modified 'gui' object is returned invisibly. The text entered by
the user at the input box, or an empty string if the dialog box was cancelled
can be obtained from \code{gui$res} (see example).
}
\description{
Prompt for some data in a modal dialog box.
}
\note{
The 'RStudio' version of this dialog box does not allow for an empty
string. So, for better portability, try never to expect an empty string from
the user (the \code{'Cancel'} button is there to dismiss the dialog box).
On MacOS, single and double quotes are temporarily replaced by their slanted
versions (unicode characters u3032 and u2033, respectively) because the
command that triggers the dialog box does not allow quotes inside strings.
Regular quotes are reset on the output. This is the only hack we found that
was working. Better solutions are welcome!
}
\examples{
\dontrun{
# Ask something...
user <- dlg_input("Who are you?", Sys.info()["user"])$res
if (!length(user)) {# The user clicked the 'cancel' button
  cat("OK, you prefer to stay anonymous!\n")
} else {
  cat("Hello", user, "\n")
}
}
}
\seealso{
\code{\link[=dlg_list]{dlg_list()}}, \code{\link[=dlg_form]{dlg_form()}}, \code{\link[=dlg_message]{dlg_message()}}
}
\concept{Modal dialog box}
\keyword{misc}
