% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/menu.R
\name{menu}
\alias{menu}
\alias{menu_names}
\alias{menuNames}
\alias{menu_items}
\alias{menuItems}
\alias{menu_add}
\alias{menuAdd}
\alias{menu_add_item}
\alias{menuAddItem}
\alias{menu_del}
\alias{menuDel}
\alias{menu_del_item}
\alias{menuDelItem}
\title{Manage custom R menus.}
\usage{
menu_names()

menuNames()

menu_items(menuname)

menuItems(menuname)

menu_add(menuname)

menuAdd(menuname)

menu_add_item(menuname, itemname, action)

menuAddItem(menuname, itemname, action)

menu_del(menuname)

menuDel(menuname)

menu_del_item(menuname, itemname)

menuDelItem(menuname, itemname)
}
\arguments{
\item{menuname}{A character string naming a menu.}

\item{itemname}{A character string naming a menu item on an existing menu.}

\item{action}{A character string with the action to perform when the menu item
is selected, or \code{"none"} for no action. Use \code{"enable"} or \code{"disable"} to
activate or deactivate an existing menu item.}
}
\value{
These function return \code{NULL} invisibly. They are used for their
side-effect of creating, changing, or deleting custom R menus.
}
\description{
Create, populate and rework custom R menus.
}
\details{
On Windows, the function manages custom menus in RGui the same way
as \code{winMenuAdd()} and similar function do. Menus are added to the right and
new menu entries are added to the bottom of the menu. It is currently not
possible to add menus for \strong{'Rterm.exe'} under Windows.

On Unix/Linux, under Gnome, you must install a little Gtk2 program called
\code{ctxmenu}, as well as a few other utilities to manage the menu actions. You
can download corresponding files (GPL-2 license) and get further instructions
at the bottom of http://www.sciviews.org/SciViews-R/. The \R code in
\strong{'svDialogs'} only creates menu configuration files in \verb{~/.ctxmenu/tmp/} and
only in interactive \R session and after the user agrees to do so (unless
\code{options(svDialogs.tmpfiles = TRUE)}).
Once you installed these files, you can access the menus by setting up
keyboard shortcuts to activate main and context menus. The respective
commands are \code{ctxmenu-main} and \code{ctxmenu-context} and you can use the
preference panel to assign, e.g., \verb{<shift-menu>} and \verb{<ctrl-menu>}, or other
keyboard shortcuts to these commands. Once everything is set up, you should
see your menus appearing when a console where \R + \strong{'svDialogs'} runs is the
active window and you hit these shortcuts (after you have defined at least
one custom menu). Note also that you can define custom context menus for
other applications too, see the \code{README} file in the \code{ctxmenu} download.

On MacOS, these functions are not implemented yet (but see source of the
package for experimental code commented out and try the JGR version for a
first implementation there).

Action is treated as \R input (echoed at the command line, parsed and
executed), except if it is \code{"none"}. In this case, no action is run when the
menu item is selected (merely as a placeholder for future menu actions). You
can change the action of an existing menu by reissuing the command with a
different action argument.

If the \verb{menuname=} parameter of \code{menu_add_item()} does not exists, it is
automatically created. For creating submenus, separate successive menu names
with slashes. Use \code{"-"} as name for separation menus under Windows or
Unix/Linux.
}
\examples{
\dontrun{
# A quick default directory changer
setwd(dlg_dir(default = getwd())$res)
}
}
\seealso{
\code{\link[=dlg_open]{dlg_open()}}, \code{\link[=dlg_save]{dlg_save()}}
}
\concept{Modal dialog box}
\keyword{misc}
