% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlg_message.tcltkGUI.R
\name{dlg_message.tcltkGUI}
\alias{dlg_message.tcltkGUI}
\title{A Tcl/Tk version of the {svDialogs} message box}
\usage{
\method{dlg_message}{tcltkGUI}(
  message,
  type = c("ok", "okcancel", "yesno", "yesnocancel"),
  ...,
  gui = .GUI
)
}
\arguments{
\item{message}{The message to display in the dialog box.}

\item{type}{The type of dialog box: \code{'ok'}, \code{'okcancel'}, \code{'yesno'} or
\code{'yesnocancel'}.}

\item{...}{Not used yet.}

\item{gui}{The 'gui' object concerned by this dialog box.}
}
\value{
The button pressed by the user.
}
\description{
A Tcl/Tk version of the {svDialogs} message box
}
\examples{
library(svDialogstcltk) # Tcl/Tk dialog boxes are now used by default
\dontrun{
# A simple information box
dlg_message("Hello world!")$res

# Ask to continue
dlg_message(c("This is a long task!", "Continue?"), "okcancel")$res

# Ask a question
dlg_message("Do you like apples?", "yesno")$res

# Idem, but one can interrupt too
res <- dlg_message("Do you like oranges?", "yesnocancel")$res
if (res == "cancel")
  cat("Ah, ah! You refuse to answer!\n")
}
}
\seealso{
\code{\link[svDialogs:dlg_message]{svDialogs::dlg_message()}}
}
\concept{Modal dialog box}
\keyword{misc}
