% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_wild.R
\name{wild.boot}
\alias{wild.boot}
\title{Wild bootstrap for IRFs of identified SVARs}
\usage{
wild.boot(x, rademacher = FALSE, horizon, nboot, nc = 1, dd = NULL,
  signrest = NULL, itermax = 300, steptol = 200, iter2 = 50)
}
\arguments{
\item{x}{SVAR object of class "svars"}

\item{rademacher}{If rademacher="TRUE", the Rademacher distribution is used to generate the bootstrap samples}

\item{horizon}{Time horizon for impulse response functions}

\item{nboot}{Number of bootstrap iterations}

\item{nc}{Number of processor cores (Not available on windows machines)}

\item{dd}{Object of class 'indepTestDist'. A simulated independent sample of the same size as the data.
roxIf not supplied, it will be calculated by the function}

\item{signrest}{A list with vectors containing 1 and -1, e.g. c(1,-1,1), indicating a sign pattern of specific shocks to be tested
with the help of the bootstrap samples.}

\item{itermax}{Maximum number of iterations for DEoptim}

\item{steptol}{Tolerance for steps without improvement for DEoptim}

\item{iter2}{Number of iterations for the second optimization}
}
\value{
A list of class "sboot" with elements
\item{boot_mean}{Mean of bootstrapped covariance decompositions}
\item{sign_complete}{Frequency of appearance of the complete sign pattern in all bootstrapped covaraince decompositions}
\item{sign_part}{Frequency of bootstrapped covariance decompositions which conform the complete predetermined sign pattern. If signrest=NULL,
 the frequency of bootstrapped covariance decompositions that hold the same sign pattern as the point estimate is provided.}
\item{sign_part}{Frequency of single shocks in all bootstrapped covariance decompositions which accord to a specific predetermined sign pattern
 }
}
\description{
Calculating confidence bands for impulse response functions via wild bootstrap techniques (Goncalves and Kilian, 2004).
}
\examples{
\donttest{
# data contains quarterly observations from 1965Q1 to 2008Q3
# x = output gap
# pi = inflation
# i = interest rates
set.seed(23211)
v1 <- vars::VAR(USA, lag.max = 10, ic = "AIC" )
x1 <- id.dc(v1)
summary(x1)

# impulse response analysis with confidence bands
# Checking how often theory based impact relations appear
signrest <- list(demand = c(1,1,1), supply = c(-1,1,1), money = c(-1,-1,1))
bb <- wild.boot(x1, rademacher = TRUE, nboot = 500, horizon = 30, nc = 1, signrest = signrest)
summary(bb)
plot(bb, lowerq = 0.16, upperq = 0.84)
}


}
\references{
Goncalves, S., Kilian, L., 2004. Bootstrapping autoregressions with conditional heteroskedasticity of unknown form. Journal of Econometrics 123, 89-120.\cr
  Herwartz, H., 2017. Hodges Lehmann detection of structural shocks -
       An analysis of macroeconomic dynamics in the Euro Area, Oxford Bulletin of Economics and Statistics
}
\seealso{
\code{\link{id.cvm}}, \code{\link{id.dc}}, \code{\link{id.ngml}} or \code{\link{id.cv}}
}
