% Generated by roxygen2 (4.0.2): do not edit by hand
\name{fast_sca}
\alias{fast_sca}
\title{Simple Correspondence Analysis}
\usage{
fast_sca(dat)
}
\arguments{
\item{dat}{Input data: can be a table or a data frame (but the data frame must have only two columns).}
}
\value{
A list with components:
\item{\code{val} }{The eigenvalues or principal inertias, indicating how much each latent axis explains.}
\item{\code{pos1} }{The coordinates of the first set of levels (\emph{viz.} the row levels of a frequency table).}
\item{\code{pos2} }{The coordinates of the second set of levels (\emph{viz.} the column levels of a frequency table).}
}
\description{
A fast procedure for computing simple correspondence analysis.
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\\t", quote = "\\"", encoding = "UTF-8")
sca.SndT_Fra <- fast_sca(SndT_Fra)
sca.SndT_Fra
}
\references{
Greenacre, M. (2007) \emph{Correspondence analysis in practice, Second edition}. Boca Raton: Chapman and Hall/CRC.
}

