% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/das_effort_strata.R
\name{das_effort_strata}
\alias{das_effort_strata}
\alias{das_effort_strata.data.frame}
\alias{das_effort_strata.das_df}
\title{Split effort by strata}
\usage{
das_effort_strata(x, ...)

\method{das_effort_strata}{data.frame}(x, ...)

\method{das_effort_strata}{das_df}(x, strata.files, ...)
}
\arguments{
\item{x}{an object of class \code{das_df},
or a data frame that can be coerced to class \code{das_df}}

\item{...}{ignored}

\item{strata.files}{list of path(s) of the stratum CSV file(s);
see \code{\link{das_effort}}}
}
\value{
The data frame x, with 1) columns added that
  indicate a) if the point was in a particular stratum (see \code{\link{das_intersects_strata}}), and
  b) the index of the stratum in \code{strata.files}
  (column name 'stratum'; 0 if the point intersects with no strata), and
  2) two rows added for each strata crossing
  that occurs between something other than an E and R.
  These rows are necessary because of how \code{das_effort} processes effort.
  The added rows are the same as the event previous to the strata crossing, except:
  \itemize{
    \item They have the event code "strataE" and "strataR", respectively
    \item Their coordinates are the coordinates of the intersection of
      the effort line and the stratum boundary
    \item Their 'idx_eff' values are plus 0.4 and 0.5, respectively
    \item The second added row has the same stratum info as the point
      immediately after the stratum boundary crossing
  }
}
\description{
Split DAS effort where it intersects with a stratum boundary
}
\details{
This function should only be called by \code{\link{das_effort}},
  i.e. it should not be called by users in their personal scripts.
  Practically speaking, this functions splits the effort line wherever it crosses a stratum line.
  This point of intersection is interpolated;
  specifically, it is determined using \code{\link[sf:geos_binary_ops]{st_intersection}}.
  Thus, any effort will be first split at these effort-stratum boundary intersection points,
  and then using the specified method (e.g. condition).
}
