% Generated by roxygen2 (4.0.1): do not edit by hand
\name{omnitest}
\alias{omnitest}
\title{Test for a correct expression, a correct value, or both.}
\usage{
omnitest(correctExpr = NULL, correctVal = NULL, strict = FALSE)
}
\arguments{
\item{correctExpr}{the correct or expected expression as a string}

\item{correctVal}{the correct value (numeric or character)}

\item{strict}{a logical value indicating that the expression should be as expected even if the value is correct. If \code{FALSE} (the default) a correct value will pass the test even if the expression is not as expected, but a notification will be issued.}
}
\description{
Omnitest can test for a correct expression, a correct value,
or both. In the case of values it is limited to testing for
character or numeric vectors of length 1.
}
\examples{
\dontrun{

  # Test that a user has chosen a correct menu item
  #
  omnitest(correctVal='Men in a college dorm.')

  # Test that a user has entered a correct number at the
  # command line
  #
  omnitest(correctVal=19)

  # Test that a user has entered a particular command
  #
  omnitest('myVar <- c(3, 5, 7)')

  # Test that a user has entered a command which computes
  # a specific value but perhaps in a different manner
  # than anticipated
  #
  omnitest('sd(x)^2', 5.95)
  #
  # If the user enters sd(x)*sd(x), rather than sd(x)^2, a notification
  # will be issued, but the test will not fail.

  # Test that a user has entered a command which computes
  # a specific value in a particular way
  #
  omnitest('sd(x)^2', 5.95, strict=TRUE)
  #
  # In this case, if the user enters sd(x)*sd(x) the test will fail.

  }
}
\seealso{
Other AnswerTests: \code{\link{AnswerTests}};
  \code{\link{any_of_exprs}};
  \code{\link{expr_creates_var}};
  \code{\link{expr_identical_to}}; \code{\link{expr_is_a}};
  \code{\link{expr_uses_func}};
  \code{\link{func_of_newvar_equals}};
  \code{\link{val_has_length}}; \code{\link{val_matches}};
  \code{\link{var_is_a}}
}

