% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cantonalvotes.R
\name{plot_cantonalvotes}
\alias{plot_cantonalvotes}
\title{Plot Cantonal Votes}
\usage{
plot_cantonalvotes(
  votedate = NULL,
  vote_id = NULL,
  geolevel = "municipality",
  measure = "result",
  standardize = T,
  language = "DE",
  theme = "srf"
)
}
\arguments{
\item{votedate}{date of the ballot. Default: most recent ballot available.}

\item{vote_id}{id of the vote. Default: first id mentioned in the data set.}

\item{geolevel}{geographical level. Options: district", "municipality" or "zh_counting_districts".}

\item{measure}{measure to color the administrative units. Options: "result" for the yes vote share or "turnout"
for the voter turnout of a given vote.}

\item{standardize}{if \code{TRUE}, the scale of the measure ranges from 0 to 100 percent. Recommended for comparisons 
between votes.}

\item{language}{defines the language. Options: "DE" for German, "FR" for French, "IT" for Italian or "RM" for Romansh.}

\item{theme}{defines basic appearance of the map. Five options are available: "srf" for a theme inspired by the
plots of Swiss Radio and Television, and "A" to "E" for the viridis color scales magma, inferno, plasma, viridis and cividis.}
}
\value{
a ggplot object
}
\description{
\code{plot_cantonalvotes} plots the results of cantonal votes in a choropleth map using ggplot2.
}
\examples{

# Plot the most recent cantonal vote
plot_cantonalvotes()

# Plot a specific cantonal vote
plot_cantonalvotes(votedate = "2020-02-09", vote_id = 104945)

}
