% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\name{changeParameters}
\alias{changeParameters}
\title{Change of parameters in a 'symbolicQspray' polynomial}
\usage{
changeParameters(Qspray, newParameters)
}
\arguments{
\item{Qspray}{a \code{symbolicQspray} polynomial}

\item{newParameters}{a list containing at least \code{n} \code{qspray}
objects, or objects coercible to \code{qspray} objects, where \code{n} is
the number of parameters in the symbolic polynomial given in the
\code{Qspray} argument}
}
\value{
The \code{symbolicQspray} polynomial obtained by replacing the
  parameters of the symbolic polynomial given in the \code{Qspray} argument
  with the polynomials given in the \code{newParameters} argument.
}
\description{
Replaces the parameters of a \code{symbolicQspray} polynomial
  (which are \code{qspray} objects) with some \code{qspray} polynomials.
  E.g. you have a polynomial with two parameters \eqn{P_{a,b}(x)} and you
  want the polynomial \eqn{P_{a+1,b+1}(x)} (see example).
}
\examples{
library(symbolicQspray)
( JP <- JacobiPolynomial(2) ) # a univariate polynomial with two parameters
a1 <- qlone(1)
a2 <- qlone(2)
changeParameters(JP, list(a1, a2)) == JP # should be TRUE
changeParameters(JP, list(a1+1, a2+1))
}
\seealso{
If you want to change the variables of a symbolic qspray, use
  \code{\link{changeVariables}}. If you want to assign some values to
  its parameters, use \code{\link{substituteParameters}}.
}
