% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_cuttime_nc.R
\name{tidy_cuttime_nc}
\alias{tidy_cuttime_nc}
\title{Format a 3D-array to a S-mode data frame and set the time period}
\usage{
tidy_cuttime_nc(datalist, season = NULL, year_range = NULL)
}
\arguments{
\item{datalist}{List. 3D-array of atmospheric or environmental variable, longitudes, latitudes and time. I.e. the list returned by \code{read_nc}.}

\item{season}{Character. Name of the season wanted (i.g. "winter", "spring", "summer", "fall").}

\item{year_range}{vector. Starting and ending year wanted to subset the data.}
}
\value{
A list with: \itemize{
   \item{A vector of dates.}
   \item{A dataframe of the variable in S-mode.}
   \item{A character with the name of the season}
}
}
\description{
This function format the 3D-array output from \code{read_nc} function to a S-mode dataframe (variables = grid points, observations = days). Optionally, you can set the time period between specific years and/or specify if you want work with the full year or only with 3-month season.
}
\examples{
# Load data (mslp or precp_grid)
data(mslp)
# Converting our data into a S-mode, but without modifying time period
smode_mslp <- tidy_cuttime_nc(mslp)
# matrix conversion and setting time period for winters between 2001 and 2010
smode_mslp <- tidy_cuttime_nc(mslp, season = "winter",
                             year_range = c(2001,2010))

}
\seealso{
\code{\link{read_nc}}
}
