% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_anneal_wrappers.R
\name{all_geog_optimize_microdata}
\alias{all_geog_optimize_microdata}
\title{Optimize the selection of a micro data population for a set of geographies.}
\usage{
all_geog_optimize_microdata(macro_micro, prob_name = "p",
  constraint_list_list, p_accept = 0.05, max_iter = 10000L,
  seed = sample(1L:10000L, size = 1, replace = FALSE), verbose = TRUE)
}
\arguments{
\item{macro_micro}{The geographical dataset of macro and micro data. Should be of class 
\code{"macro_micro"}.}

\item{prob_name}{It is assumed that observations are weighted and do not have an equal probability
of occurance. This string specifies the variable within each dataset that contains the probability
of selection.}

\item{constraint_list_list}{A list of constraint lists. See \code{\link{add_constraint}}, 
\code{\link{all_geogs_add_constraint}}}

\item{p_accept}{The acceptance probability for the Metropolis acceptance criteria.}

\item{max_iter}{The maximum number of allowable iterations. Defaults to \code{10000L}}

\item{seed}{A seed for reproducibility. See \code{\link[base]{set.seed}}}

\item{verbose}{Logical. Do you wish to see verbose output? Defaults to \code{TRUE}}
}
\description{
Optimize the candidate micro datasets such that the lowest loss against the 
macro dataset constraints are obtained. Loss is defined here as total absolute error (TAE)
and constraints are defined by the \code{constraint_list_list}. Optimization is done by
simulated annealing and geographies are run in parallel.
}
\examples{
\dontrun{
 # assumes that micro_synthetic and cll already exist in your environment
 # see: examples for derive_synth_datasets() and all_geogs_add_constraint()
 optimized_la <- all_geog_optimize_microdata(micro_synthetic, prob_name= "p", 
     constraint_list_list= cll, p_accept= 0.01, max_iter= 1000L)
}
}
\seealso{
\code{\link{optimize_microdata}}
}

