% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_Chaotic.R
\name{data.gen.Logistic}
\alias{data.gen.Logistic}
\title{Logistic map}
\usage{
data.gen.Logistic(
  nobs = 5000,
  r = 4,
  start = runif(n = 1, min = 0, max = 1),
  s,
  do.plot = TRUE
)
}
\arguments{
\item{nobs}{Length of the generated time series. Default: 5000 samples.}

\item{r}{The \emph{r} parameter. Default: 4}

\item{start}{A numeric value indicating the starting value for the time series.
If the starting point is not specified, it is generated randomly.}

\item{s}{The level of noise, default 0.}

\item{do.plot}{Logical value. If TRUE (default value), a plot of the generated Logistic system is shown.}
}
\value{
A vector of time series.
}
\description{
Generates a time series using the logistic map.
}
\details{
The logistic map is defined as follows:
\deqn{x_n = r  \cdot  x_{n-1}   \cdot  (1 - x_{n-1})}{x[n] = r * x[n-1]  * (1 - x[n-1])}
}
\examples{
Logistic.map=data.gen.Logistic(nobs = 1000, do.plot=TRUE)
}
\references{
Constantino A. Garcia (2019). nonlinearTseries: Nonlinear Time Series Analysis. R package version 0.2.7. https://CRAN.R-project.org/package=nonlinearTseries
}
