# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Crates a deep copy of a matrix
#'
#' Useful  when calling \code{\link{ERE_step_cycle}} or
#' \code{\link{GibbsSteps_kcycle}} to ensure that
#' there are no side effects for the return values.
#' @param M A matrix
#' @return A deep copy of the matrix.
#' @examples
#' lambda <- matrix(0.5,nrow=2,ncol=2)
#' p <- matrix(0.7, nrow=2,ncol=2)
#' L <- matrix(rexp(4),nrow=2);
#' L
#' Lold <- L
#' Lcopy <- cloneMatrix(L)
#' ERE_step_cycle(r=c(0,1),c=c(0,1),L=L,lambda=lambda,p=p)
#'
#' L     ## new value
#' Lold  ## equal to L !!!
#' Lcopy ## still has the original value
#' @export
cloneMatrix <- function(M) {
    .Call('systemicrisk_cloneMatrix', PACKAGE = 'systemicrisk', M)
}

#' @title Does one Gibbs Step on a cycle
#'
#' @param r Row indies of cycle, starting at 0 (vector of length k)
#' @param c Column indices of cycle, starting at 0 (vector of length k)
#' @param L nxn matrix with nonnegative values (will be modified)
#' @param lambda nxn matrix of intensities
#' @param p nxn matrix of probabilities (must be in [0,1] and 0 on diagonal)
#' @param eps Threshold for values to be interpreted as equal to 0 (default = 1e-10)
#' @return no return value
#'
#' @examples
#' L=matrix(rexp(9),nrow=3)
#' lambda <- matrix(0.5,nrow=3,ncol=3)
#' p <- matrix(0.7, nrow=3,ncol=3)
#' ERE_step_cycle(r=c(0,1),c=c(1,2),L=L,lambda=lambda,p=p)
#' ERE_step_cycle(r=c(0,1,2),c=c(0,1,2),L=L,lambda=lambda,p=p)
#' ERE_step_cycle(r=c(0,1,2),c=c(2,1,0),L=L,lambda=lambda,p=p)
#'
#' @export
ERE_step_cycle <- function(r, c, L, lambda, p, eps = 1e-10) {
    invisible(.Call('systemicrisk_ERE_step_cycle', PACKAGE = 'systemicrisk', r, c, L, lambda, p, eps))
}

#' Gibbs sampling step of a matrix in the ERE model
#'
#' The sampling is conditional on row and column sums and uses k-cycle steps. Then dimensions of L, lambda and p must match.
#'
#' @param L Starting matrix - will be modified to contain the results.
#' @param lambda  Matrix of intensities
#' @param p Matrix of probabilities (must be in [0,1])
#' @param it Number of iterations (default=1000)
#' @param eps Threshold for values to be interpreted as equal to 0 (default = 1e-10)
#' @param debug Should addtional debug information be printed? (0 no output, 1 output debug information)
#' @return no return value
#'
#' @examples
#' L <- matrix(c(1,2,3,4,5,6,7,8,9),nrow=3)
#' diag(L) <- 0
#' lambda <- matrix(0.5,nrow=3,ncol=3)
#' p <- matrix(0.7, nrow=3,ncol=3)
#' diag(p) <- 0
#' GibbsSteps_kcycle(L=L,lambda=lambda,p=p)
#' L
#' L <- matrix(1:16,nrow=4)
#' diag(L) <- 0
#' lambda <- matrix(0.5,nrow=4,ncol=4)
#' p <- matrix(0.25, nrow=4,ncol=4)
#' diag(p) <- 0
#' GibbsSteps_kcycle(L=L,lambda=lambda,p=p)
#' L
#' @export
GibbsSteps_kcycle <- function(L, lambda, p, it = 1000L, eps = 1e-10, debug = 0L) {
    invisible(.Call('systemicrisk_GibbsSteps_kcycle', PACKAGE = 'systemicrisk', L, lambda, p, it, eps, debug))
}

