% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/lib_Network_Evaluations.R
\name{default}
\alias{default}
\title{Default of Banks}
\usage{
default(L, ea, el = 0, method = c("clearing", "cascade"), ...)
}
\arguments{
\item{L}{liability matrix}

\item{ea}{vector of external assets}

\item{el}{vector of external liabilites.}

\item{method}{the method to be used. See Details.}

\item{...}{Additional information for the various methods. See Details.}
}
\value{
A list with at least one element "defaultind", which is a
vector indicating which banks default (1=default, 0= no
default). Depending on the method, other results such as the
clearing vector may also be reported.
}
\description{
Computes bank defaults based on a liabilities matrix and external assets and liabilities.
}
\examples{
ea <- c(1/2,5/8,3/4)
el <- c(3/2,1/2,1/2)
x <- 0.5
L <- matrix(c(0,x,1-x,1-x,0,x,x,1-x,0),nrow=3)
default(L,ea,el)
default(L,ea,el,"cascade")
}
\seealso{
\code{\link{default_cascade}},  \code{\link{default_clearing}},
}

