% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VERBS-transmute.R
\name{transmute-table.express}
\alias{transmute-table.express}
\alias{transmute.ExprBuilder}
\title{Alias for select}
\usage{
\method{transmute}{ExprBuilder}(.data, ...,
  .parse = getOption("table.express.parse", FALSE),
  .chain = getOption("table.express.chain", TRUE))
}
\arguments{
\item{.data}{An instance of \link{ExprBuilder}.}

\item{...}{Clause for selecting/computing on columns. The \code{j} inside the \code{data.table}'s frame.}

\item{.parse}{Logical. Whether to apply \code{\link[rlang:parse_expr]{rlang::parse_expr()}} to obtain the expressions.}

\item{.chain}{Logical. Should a new frame be automatically chained to the expression if the
clause being set already exists?}
}
\description{
Because of the way \code{data.table} and the \link{select-table.express} method work, a
\code{\link[dplyr:transmute]{dplyr::transmute()}} equivalent can be specified as a \code{select} clause.
}
\details{
If \code{length(...) == 1L} and the expression is a call to \code{:} (e.g. \code{a:c}) or
\link[tidyselect:select_helpers]{tidyselect::select_helpers}, then it will be taken as the single expression for the select
clause, otherwise everything in \code{...} will be wrapped in a call to \code{\link[base:list]{base::list()}}.

To see more examples, check the
\href{https://asardaes.github.io/table.express/articles/table.express.html}{vignette}, or the
\link{table.express-package} entry.
}
\examples{

data("mtcars")

data.table::as.data.table(mtcars) \%>\%
    start_expr \%>\%
    transmute(ans = mpg * 2)

}
