% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VERBS-mutate.R
\name{mutate-table.express}
\alias{mutate-table.express}
\alias{mutate.ExprBuilder}
\title{Add or update columns}
\usage{
\method{mutate}{ExprBuilder}(.data, ..., .sequential = FALSE,
  .unquote_names = TRUE, .parse = getOption("table.express.parse",
  FALSE), .chain = getOption("table.express.chain", TRUE))
}
\arguments{
\item{.data}{An instance of \link{ExprBuilder}.}

\item{...}{Mutation clauses.}

\item{.sequential}{If \code{TRUE}, each expression in \code{...} is assigned to a separate frame in order
to enable usage of newly created columns.}

\item{.unquote_names}{Passed to \code{\link[rlang:enexprs]{rlang::enexprs()}}. Set to \code{FALSE} if you want to pass the single
\code{\link[data.table:set]{:=}} expression.}

\item{.parse}{Logical. Whether to apply \code{\link[rlang:parse_expr]{rlang::parse_expr()}} to obtain the expressions.}

\item{.chain}{Logical. Should a new frame be automatically chained to the expression if the
clause being set already exists?}
}
\description{
Add or update columns of a \link[data.table:data.table-class]{data.table::data.table}, possibly by reference using
\code{\link[data.table:set]{:=}}.
}
\details{
To see more examples, check the
\href{https://asardaes.github.io/table.express/articles/table.express.html}{vignette}, or the
\link{table.express-package} entry.
}
\examples{

data("mtcars")
data.table::as.data.table(mtcars) \%>\%
    start_expr \%>\%
    mutate(mpg_squared = mpg ^ 2)

}
