% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VERBS-mutate_sd.R
\name{mutate_sd}
\alias{mutate_sd}
\alias{mutate_sd.ExprBuilder}
\alias{mutate_sd.EagerExprBuilder}
\alias{mutate_sd.data.table}
\title{Mutate subset of data}
\usage{
mutate_sd(.data, .SDcols, .how = identity, ...)

\method{mutate_sd}{ExprBuilder}(.data, .SDcols, .how = identity, ...,
  .pairwise = TRUE, .prefix, .suffix,
  .parse = getOption("table.express.parse", FALSE),
  .chain = getOption("table.express.chain", TRUE))

\method{mutate_sd}{EagerExprBuilder}(.data, ...,
  .parent_env = rlang::caller_env())

\method{mutate_sd}{data.table}(.data, ...)
}
\arguments{
\item{.data}{An instance of \link{ExprBuilder}.}

\item{.SDcols}{See \link[data.table:data.table]{data.table::data.table} and the details here.}

\item{.how}{The function(s) or function call(s) that will perform the transformation. If many,
a list should be used, either with \code{list()} or \code{.()}. If the list is named, the names will be
used for the new columns' names. Lambdas specified as formulas are supported.}

\item{...}{Possibly more arguments for \emph{all} functions/calls in \code{.how}.}

\item{.pairwise}{If \code{FALSE}, each function in \code{.how} is applied to each column in \code{.SDcols} (like
a cartesian product).}

\item{.prefix, .suffix}{Only relevant when \code{.how} is a function: add a prefix or suffix to the new
column's name. If neither is missing, \code{.prefix} has preference.}

\item{.parse}{Logical. Whether to apply \code{\link[rlang:parse_expr]{rlang::parse_expr()}} to obtain the expressions.}

\item{.chain}{Logical. Should a new frame be automatically chained to the expression if the
clause being set already exists?}

\item{.parent_env}{See \code{\link[=end_expr]{end_expr()}}}
}
\description{
Like \link{mutate-table.express} but possibly recycling calls.
}
\details{
This function works similar to \code{\link[=transmute_sd]{transmute_sd()}} but keeps all columns and \emph{can} modify by
reference, like \link{mutate-table.express}. It can serve like
\link[dplyr:mutate_all]{dplyr's scoped mutation variants} depending on what's given to \code{.SDcols}.

Additionally, \code{.SDcols} supports:
\itemize{
\item \link[tidyselect:select_helpers]{tidyselect::select_helpers}
\item A predicate using the \code{.COL} pronoun that should return a single logical when \code{.COL} is
replaced by a \emph{column} of the data.
\item A formula using \code{.} or \code{.x} instead of the aforementioned \code{.COL}.
}

The caveat is that the expression is evaluated eagerly, i.e. with the currently captured
\code{data.table}. Consider using \code{\link[=chain]{chain()}} to explicitly capture intermediate results as actual
\code{data.table}s.

To see more examples, check the
\href{https://asardaes.github.io/table.express/articles/table.express.html}{vignette}, or the
\link{table.express-package} entry.
}
\examples{

data("mtcars")

data.table::as.data.table(mtcars) \%>\%
    start_expr \%>\%
    mutate_sd(c("mpg", "cyl"), ~ .x * 2)

}
