% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfa.tab.multi.R
\name{cfa.tab.multi}
\alias{cfa.tab.multi}
\title{A Function for Creating  Publication Quality Tables with CFA fit indices from several lavaan objects.}
\usage{
cfa.tab.multi(x, y, z = NULL, a = NULL, b = NULL, robust = FALSE)
}
\arguments{
\item{x}{first object of class lavaan (Mandatory).}

\item{y}{second object of class lavaan (Mandatory).}

\item{z}{third object of class lavaan (Optional).}

\item{a}{fourth object of class lavaan (Optional).}

\item{b}{fifth object of class lavaan (Optional).}

\item{robust}{If TRUE, will provide robust fit indices when applicable instead of the default indices.}
}
\value{
A  summary of CFA fit indices from several lavaan class objects. Output object is a matrix.
}
\description{
Often researchers are required to show fit indices from several CFA models.
This function will create publication worthy tables with CFA fit indices
from several lavaan class objects.
#' To run this function successfully one need to provide at least two lavaan  objects.
This command supports up-to five lavaan models.
}
\examples{
data <- tabledown::FFMQ.CFA
FF.model.Original <- "Observe =~ item1 + item6 + item11 + item15 +
item20 + item26 + item31 + item 36
Describe =~ item2 + item7 + Ritem12 + Ritem16 + Ritem22 + item27 +
item32 + item37
Awareness =~ Ritem5 + Ritem8 + Ritem13 + Ritem18 + Ritem23 + Ritem28 +
Ritem34 + Ritem38
Nonjudge =~ Ritem3 + Ritem10 + Ritem14 + Ritem17 + Ritem25 +
Ritem30+ Ritem35 + Ritem39
Nonreact =~ item4 + item9 + item19 + item21 + item24 + item29 + item33 "
fit.original <- lavaan::cfa(FF.model.Original, data = data,
estimator = "MLR", mimic = "Mplus")
FF.model.Cor <-  "Observe =~ item1 + item6 + item11 + item15 +
item20 + item26 + item31 + item 36
 Describe =~ item2 + item7   + item27 + item32 + item37
Awareness =~ Ritem5 + Ritem8 + Ritem13 + Ritem18 + Ritem23 +
Ritem28 + Ritem34
Nonjudge =~  Ritem10 + Ritem14 + Ritem25 + Ritem30+ Ritem35
 Nonreact =~ item4 + item9 + item19 + item21 + item24 + item29 + item33
Ritem28 ~~ Ritem34
Ritem23 ~~ Ritem34"
fit.Cor <- lavaan::cfa(FF.model.Cor, data = data, estimator = "MLR", mimic = "Mplus")
FF.short <- "Observe =~ item36 + item26 +item20 + item11
Describe =~ item2 + item7 + item27 +  item32
Awareness =~  Ritem8 + Ritem13 + Ritem23 + Ritem28
Nonjudge =~ Ritem10  + Ritem25 + Ritem30 + Ritem35
Nonreact =~ item9 + item19 + item21 + item24"
fit.short <- lavaan::cfa(FF.short, data = data, estimator = "MLR", mimic = "Mplus")
table <- cfa.tab.multi(fit.original, fit.Cor, fit.short, robust = TRUE)

}
