% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggicc.R
\name{ggicc}
\alias{ggicc}
\title{A Function for Creating  Publication Quality Item Response Theory based item characteristic plot.}
\usage{
ggicc(model, item, theta)
}
\arguments{
\item{model}{A mirt package fitted object.}

\item{item}{Item number (i.e. 1,2,3,4).}

\item{theta}{Theta range. Put only one number. Theta =3 will be considered as theta range (-3 to 3).}
}
\value{
A publication quality item characteristic plot. Output object is a ggplot object.
}
\description{
This function will create publication worthy Item Response Theory based item characteristic plot using ggplot2 from objects created from
mirt pack.
Using ggplot2 will enable the user to modify the item characteristic plot.
}
\examples{
data <- tabledown::Rotter[, 11:31]
model <- mirt::mirt(data, model = 1, itemtype = '2PL', SE = TRUE, Se.type = 'MHRM')

plot <- tabledown::ggicc(model, 1, 3)
}
